/*
 * Decompiled with CFR 0.152.
 */
package com.jayway.restassured.path.json;

import com.jayway.restassured.assertion.AssertParameter;
import com.jayway.restassured.assertion.JSONAssertion;
import com.jayway.restassured.exception.ParsePathException;
import com.jayway.restassured.internal.mapping.ObjectMapping;
import com.jayway.restassured.internal.path.ObjectConverter;
import com.jayway.restassured.internal.support.Prettifier;
import com.jayway.restassured.parsing.Parser;
import groovy.json.JsonBuilder;
import groovy.json.JsonOutput;
import groovy.json.JsonSlurper;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JsonPath {
    private final Object json;
    private String rootPath = "";

    public JsonPath(String text) {
        this.json = new JsonSlurper().parseText(text);
    }

    public JsonPath(URL url) {
        this.json = this.parseURL(url);
    }

    public JsonPath(InputStream stream) {
        this.json = this.parseInputStream(stream);
    }

    public JsonPath(File file) {
        this.json = this.parseFile(file);
    }

    public JsonPath(Reader reader) {
        this.json = this.parseReader(reader);
    }

    public <T> T get() {
        return this.get("");
    }

    public <T> T get(String path) {
        JSONAssertion jsonAssertion = this.createJsonAssertion(path);
        return (T)jsonAssertion.getResult(this.json);
    }

    public boolean getBoolean(String path) {
        return ObjectConverter.convertObjectTo(this.get(path), Boolean.class);
    }

    public char getChar(String path) {
        return ObjectConverter.convertObjectTo(this.get(path), Character.class).charValue();
    }

    public int getInt(String path) {
        Object value = this.get(path);
        if (value instanceof Integer) {
            return (Integer)value;
        }
        if (value instanceof Short) {
            return ((Short)value).intValue();
        }
        if (value instanceof Long) {
            return ((Long)value).intValue();
        }
        return ObjectConverter.convertObjectTo(value, Integer.class);
    }

    public byte getByte(String path) {
        Object value = this.get(path);
        if (value instanceof Byte) {
            return (Byte)value;
        }
        if (value instanceof Long) {
            return ((Long)value).byteValue();
        }
        if (value instanceof Integer) {
            return ((Integer)value).byteValue();
        }
        return ObjectConverter.convertObjectTo(value, Byte.class);
    }

    public short getShort(String path) {
        Object value = this.get(path);
        if (value instanceof Short) {
            return (Short)value;
        }
        if (value instanceof Long) {
            return ((Long)value).shortValue();
        }
        if (value instanceof Integer) {
            return ((Integer)value).shortValue();
        }
        return ObjectConverter.convertObjectTo(value, Short.class);
    }

    public float getFloat(String path) {
        Object value = this.get(path);
        if (value instanceof Double) {
            return ((Double)value).floatValue();
        }
        return ObjectConverter.convertObjectTo(value, Float.class).floatValue();
    }

    public double getDouble(String path) {
        Object value = this.get(path);
        if (value instanceof Double) {
            return (Double)value;
        }
        return ObjectConverter.convertObjectTo(value, Double.class);
    }

    public long getLong(String path) {
        Object value = this.get(path);
        if (value instanceof Long) {
            return (Long)value;
        }
        if (value instanceof Short) {
            return ((Short)value).longValue();
        }
        if (value instanceof Integer) {
            return ((Integer)value).longValue();
        }
        return ObjectConverter.convertObjectTo(value, Long.class);
    }

    public String getString(String path) {
        return ObjectConverter.convertObjectTo(this.get(path), String.class);
    }

    public <T> List<T> getList(String path) {
        return (List)this.get(path);
    }

    public <T> List<T> getList(String path, Class<T> genericType) {
        List original = (List)this.get(path);
        LinkedList<T> newList = new LinkedList<T>();
        for (Object t : original) {
            newList.add(ObjectConverter.convertObjectTo(t, genericType));
        }
        return Collections.unmodifiableList(newList);
    }

    public <K, V> Map<K, V> getMap(String path) {
        return (Map)this.get(path);
    }

    public <K, V> Map<K, V> getMap(String path, Class<K> keyType, Class<V> valueType) {
        Map originalMap = (Map)this.get(path);
        HashMap<Object, Object> newMap = new HashMap<Object, Object>();
        for (Map.Entry entry : originalMap.entrySet()) {
            Object key = entry.getKey() == null ? null : (Object)ObjectConverter.convertObjectTo(entry.getKey(), keyType);
            Object value = entry.getValue() == null ? null : (Object)ObjectConverter.convertObjectTo(entry.getValue(), valueType);
            newMap.put(key, value);
        }
        return Collections.unmodifiableMap(newMap);
    }

    public <T> T getObject(String path, Class<T> objectType) {
        Object object = this.getJsonObject(path);
        if (object == null) {
            return null;
        }
        if (!(object instanceof List) && !(object instanceof Map)) {
            return ObjectConverter.convertObjectTo(object, objectType);
        }
        object = new JsonBuilder(object).toString();
        return ObjectMapping.deserialize(object, objectType, "application/json", "", null);
    }

    public String prettify() {
        return new Prettifier().prettify(JsonOutput.toJson((Object)this.json), Parser.JSON);
    }

    public String prettyPrint() {
        String pretty = this.prettify();
        System.out.println(pretty);
        return pretty;
    }

    public static JsonPath given(String text) {
        return new JsonPath(text);
    }

    public static JsonPath given(InputStream stream) {
        return new JsonPath(stream);
    }

    public static JsonPath given(File file) {
        return new JsonPath(file);
    }

    public static JsonPath given(Reader reader) {
        return new JsonPath(reader);
    }

    public static JsonPath given(URL url) {
        return new JsonPath(url);
    }

    public static JsonPath with(InputStream stream) {
        return new JsonPath(stream);
    }

    public static JsonPath with(String text) {
        return new JsonPath(text);
    }

    public static JsonPath with(File file) {
        return new JsonPath(file);
    }

    public static JsonPath with(Reader reader) {
        return new JsonPath(reader);
    }

    public static JsonPath with(URL url) {
        return new JsonPath(url);
    }

    public static JsonPath from(InputStream stream) {
        return new JsonPath(stream);
    }

    public static JsonPath from(String text) {
        return new JsonPath(text);
    }

    public static JsonPath from(File file) {
        return new JsonPath(file);
    }

    public static JsonPath from(Reader reader) {
        return new JsonPath(reader);
    }

    public static JsonPath from(URL url) {
        return new JsonPath(url);
    }

    public JsonPath setRoot(String rootPath) {
        AssertParameter.notNull(rootPath, "Root path");
        this.rootPath = rootPath;
        return this;
    }

    private Object parseInputStream(final InputStream stream) {
        return new ExceptionCatcher(){

            protected Object method(JsonSlurper slurper) throws Exception {
                return slurper.parse((Reader)JsonPath.this.toReader(stream));
            }
        }.invoke();
    }

    private Object parseReader(final Reader reader) {
        return new ExceptionCatcher(){

            protected Object method(JsonSlurper slurper) throws Exception {
                return slurper.parse(reader);
            }
        }.invoke();
    }

    private Object parseFile(final File file) {
        return new ExceptionCatcher(){

            protected Object method(JsonSlurper slurper) throws Exception {
                return slurper.parse((Reader)new FileReader(file));
            }
        }.invoke();
    }

    private Object parseURL(final URL url) {
        return new ExceptionCatcher(){

            protected Object method(JsonSlurper slurper) throws Exception {
                return slurper.parse((Reader)JsonPath.this.toReader(url.openStream()));
            }
        }.invoke();
    }

    private BufferedReader toReader(InputStream in) {
        return new BufferedReader(new InputStreamReader(in));
    }

    public <T> T getJsonObject(String path) {
        JSONAssertion jsonAssertion = this.createJsonAssertion(path);
        return (T)jsonAssertion.getAsJsonObject(this.json);
    }

    private JSONAssertion createJsonAssertion(String path) {
        AssertParameter.notNull(path, "path");
        JSONAssertion jsonAssertion = new JSONAssertion();
        String root = this.rootPath.equals("") ? this.rootPath : (this.rootPath.endsWith(".") ? this.rootPath : this.rootPath + ".");
        jsonAssertion.setKey(root + path);
        return jsonAssertion;
    }

    private abstract class ExceptionCatcher {
        private ExceptionCatcher() {
        }

        protected abstract Object method(JsonSlurper var1) throws Exception;

        public Object invoke() {
            try {
                return this.method(new JsonSlurper());
            }
            catch (Exception e) {
                throw new ParsePathException("Failed to parse the Object document", e);
            }
        }
    }
}

