/*
 * Decompiled with CFR 0.152.
 */
package com.jayway.restassured.config;

import com.jayway.restassured.assertion.AssertParameter;
import com.jayway.restassured.config.DecoderConfig;
import com.jayway.restassured.config.EncoderConfig;
import com.jayway.restassured.config.HttpClientConfig;
import com.jayway.restassured.config.LogConfig;
import com.jayway.restassured.config.RedirectConfig;

public class RestAssuredConfig {
    private final RedirectConfig redirectConfig;
    private final HttpClientConfig httpClientConfig;
    private final LogConfig logConfig;
    private final EncoderConfig encoderConfig;
    private final DecoderConfig decoderConfig;

    public RestAssuredConfig() {
        this(new RedirectConfig(), new HttpClientConfig(), new LogConfig(), new EncoderConfig(), new DecoderConfig());
    }

    public RestAssuredConfig(RedirectConfig redirectConfig, HttpClientConfig httpClientConfig, LogConfig logConfig, EncoderConfig encoderConfig, DecoderConfig decoderConfig) {
        AssertParameter.notNull(redirectConfig, "Redirect Config");
        AssertParameter.notNull(httpClientConfig, "HTTP Client Config");
        AssertParameter.notNull(logConfig, "Log config");
        AssertParameter.notNull(encoderConfig, "Encoder config");
        AssertParameter.notNull(decoderConfig, "Decoder config");
        this.httpClientConfig = httpClientConfig;
        this.redirectConfig = redirectConfig;
        this.logConfig = logConfig;
        this.encoderConfig = encoderConfig;
        this.decoderConfig = decoderConfig;
    }

    public RestAssuredConfig redirect(RedirectConfig redirectConfig) {
        AssertParameter.notNull(redirectConfig, "Redirect config");
        return new RestAssuredConfig(redirectConfig, this.httpClientConfig, this.logConfig, this.encoderConfig, this.decoderConfig);
    }

    public RestAssuredConfig httpClient(HttpClientConfig httpClientConfig) {
        AssertParameter.notNull(httpClientConfig, "HTTP Client Config");
        return new RestAssuredConfig(this.redirectConfig, httpClientConfig, this.logConfig, this.encoderConfig, this.decoderConfig);
    }

    public RestAssuredConfig logConfig(LogConfig logConfig) {
        AssertParameter.notNull(logConfig, "Log config");
        return new RestAssuredConfig(this.redirectConfig, this.httpClientConfig, logConfig, this.encoderConfig, this.decoderConfig);
    }

    public RestAssuredConfig encoderConfig(EncoderConfig encoderConfig) {
        AssertParameter.notNull(encoderConfig, "Encoder config");
        return new RestAssuredConfig(this.redirectConfig, this.httpClientConfig, this.logConfig, encoderConfig, this.decoderConfig);
    }

    public RestAssuredConfig decoderConfig(DecoderConfig decoderConfig) {
        AssertParameter.notNull(this.encoderConfig, "Decoder config");
        return new RestAssuredConfig(this.redirectConfig, this.httpClientConfig, this.logConfig, this.encoderConfig, decoderConfig);
    }

    public RestAssuredConfig and() {
        return this;
    }

    public RestAssuredConfig set() {
        return this;
    }

    public RedirectConfig getRedirectConfig() {
        return this.redirectConfig;
    }

    public LogConfig getLogConfig() {
        return this.logConfig;
    }

    public HttpClientConfig getHttpClientConfig() {
        return this.httpClientConfig;
    }

    public EncoderConfig getEncoderConfig() {
        return this.encoderConfig;
    }

    public DecoderConfig getDecoderConfig() {
        return this.decoderConfig;
    }

    public static RestAssuredConfig newConfig() {
        return new RestAssuredConfig();
    }

    public static RestAssuredConfig config() {
        return new RestAssuredConfig();
    }
}

