/*
 * Decompiled with CFR 0.152.
 */
package com.jayway.restassured.parsing;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum Parser {
    XML("application/xml"),
    TEXT("text/plain"),
    JSON("application/json"),
    HTML("text/html");

    private final String contentType;

    private Parser(String contentType) {
        this.contentType = contentType;
    }

    public String getContentType() {
        return this.contentType;
    }

    public static Parser fromContentType(String contentType) {
        Parser foundParser;
        if (XML.getContentType().equals(contentType)) {
            foundParser = XML;
        } else if (JSON.getContentType().equals(contentType)) {
            foundParser = JSON;
        } else if (TEXT.getContentType().equals(contentType)) {
            foundParser = TEXT;
        } else if (HTML.getContentType().equals(contentType)) {
            foundParser = HTML;
        } else {
            throw new IllegalArgumentException("Cannot find a parser for content-type " + contentType);
        }
        return foundParser;
    }
}

