/*
 * Decompiled with CFR 0.152.
 */
package com.jayway.restassured.parsing;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum Parser {
    XML("application/xml"),
    TEXT("text/plain"),
    JSON("application/json"),
    HTML("text/html");

    private final String mimeType;

    private Parser(String mimeType) {
        this.mimeType = mimeType;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public static Parser fromMimeType(String mimeType) {
        Parser foundParser;
        if (XML.getMimeType().equals(mimeType)) {
            foundParser = XML;
        } else if (JSON.getMimeType().equals(mimeType)) {
            foundParser = JSON;
        } else if (TEXT.getMimeType().equals(mimeType)) {
            foundParser = TEXT;
        } else if (HTML.getMimeType().equals(mimeType)) {
            foundParser = HTML;
        } else {
            throw new IllegalArgumentException("Cannot find a parser for mime-type " + mimeType);
        }
        return foundParser;
    }
}

