/*
 * Decompiled with CFR 0.152.
 */
package com.jayway.restassured.path.xml;

import com.jayway.restassured.assertion.AssertParameter;
import com.jayway.restassured.assertion.XMLAssertion;
import com.jayway.restassured.exception.ParsePathException;
import groovy.util.XmlSlurper;
import groovy.util.slurpersupport.GPathResult;
import java.io.File;
import java.io.InputStream;
import java.io.Reader;
import java.net.URI;
import java.util.List;
import java.util.Map;
import org.xml.sax.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmlPath {
    private final GPathResult input;
    private String rootPath = "";

    public XmlPath(String text) {
        this.input = this.parseText(text);
    }

    public XmlPath(InputStream stream) {
        this.input = this.parseInputStream(stream);
    }

    public XmlPath(InputSource source) {
        this.input = this.parseInputSource(source);
    }

    public XmlPath(File file) {
        this.input = this.parseFile(file);
    }

    public XmlPath(Reader reader) {
        this.input = this.parseReader(reader);
    }

    public XmlPath(URI uri) {
        this.input = this.parseURI(uri);
    }

    public <T> T get(String path) {
        AssertParameter.notNull(path, "path");
        XMLAssertion xmlAssertion = new XMLAssertion();
        String root = this.rootPath.equals("") ? this.rootPath : (this.rootPath.endsWith(".") ? this.rootPath : this.rootPath + ".");
        xmlAssertion.setKey(root + path);
        return (T)xmlAssertion.getResult(this.input);
    }

    public <T> List<T> getList(String path) {
        return (List)this.get(path);
    }

    public <T> List<T> getList(String path, Class<T> genericType) {
        return (List)this.get(path);
    }

    public <K, V> Map<K, V> getMap(String path) {
        return (Map)this.get(path);
    }

    public <K, V> Map<K, V> getMap(String path, Class<K> keyType, Class<V> valueType) {
        return (Map)this.get(path);
    }

    public int getInt(String path) {
        return (Integer)this.get(path);
    }

    public boolean getBoolean(String path) {
        return (Boolean)this.get(path);
    }

    public char getChar(String path) {
        return ((Character)this.get(path)).charValue();
    }

    public byte getByte(String path) {
        return (Byte)this.get(path);
    }

    public short getShort(String path) {
        return (Short)this.get(path);
    }

    public float getFloat(String path) {
        return ((Float)this.get(path)).floatValue();
    }

    public double getDouble(String path) {
        return (Double)this.get(path);
    }

    public long getLong(String path) {
        return (Long)this.get(path);
    }

    public String getString(String path) {
        return (String)this.get(path);
    }

    public static XmlPath given(String text) {
        return new XmlPath(text);
    }

    public static XmlPath given(InputStream stream) {
        return new XmlPath(stream);
    }

    public static XmlPath given(InputSource source) {
        return new XmlPath(source);
    }

    public static XmlPath given(File file) {
        return new XmlPath(file);
    }

    public static XmlPath given(Reader reader) {
        return new XmlPath(reader);
    }

    public static XmlPath given(URI uri) {
        return new XmlPath(uri);
    }

    public static XmlPath with(InputStream stream) {
        return new XmlPath(stream);
    }

    public static XmlPath with(String text) {
        return new XmlPath(text);
    }

    public static XmlPath with(InputSource source) {
        return new XmlPath(source);
    }

    public static XmlPath with(File file) {
        return new XmlPath(file);
    }

    public static XmlPath with(Reader reader) {
        return new XmlPath(reader);
    }

    public static XmlPath with(URI uri) {
        return new XmlPath(uri);
    }

    private GPathResult parseText(final String text) {
        return new ExceptionCatcher(){

            protected GPathResult method(XmlSlurper slurper) throws Exception {
                return slurper.parseText(text);
            }
        }.invoke();
    }

    public XmlPath setRoot(String rootPath) {
        AssertParameter.notNull(rootPath, "Root path");
        this.rootPath = rootPath;
        return this;
    }

    private GPathResult parseInputStream(final InputStream stream) {
        return new ExceptionCatcher(){

            protected GPathResult method(XmlSlurper slurper) throws Exception {
                return slurper.parse(stream);
            }
        }.invoke();
    }

    private GPathResult parseReader(final Reader reader) {
        return new ExceptionCatcher(){

            protected GPathResult method(XmlSlurper slurper) throws Exception {
                return slurper.parse(reader);
            }
        }.invoke();
    }

    private GPathResult parseFile(final File file) {
        return new ExceptionCatcher(){

            protected GPathResult method(XmlSlurper slurper) throws Exception {
                return slurper.parse(file);
            }
        }.invoke();
    }

    private GPathResult parseURI(final URI uri) {
        return new ExceptionCatcher(){

            protected GPathResult method(XmlSlurper slurper) throws Exception {
                return slurper.parse(uri.toString());
            }
        }.invoke();
    }

    private GPathResult parseInputSource(final InputSource source) {
        return new ExceptionCatcher(){

            protected GPathResult method(XmlSlurper slurper) throws Exception {
                return slurper.parse(source);
            }
        }.invoke();
    }

    private abstract class ExceptionCatcher {
        private ExceptionCatcher() {
        }

        protected abstract GPathResult method(XmlSlurper var1) throws Exception;

        public GPathResult invoke() {
            try {
                return this.method(new XmlSlurper());
            }
            catch (Exception e) {
                throw new ParsePathException("Failed to parse the XML document", e);
            }
        }
    }
}

