/*
 * Decompiled with CFR 0.152.
 */
package com.jayway.restassured.config;

import com.jayway.restassured.internal.assertion.AssertParameter;
import java.io.File;
import java.security.KeyStore;
import org.apache.commons.lang3.Validate;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.conn.ssl.X509HostnameVerifier;

public class SSLConfig {
    private static final int UNDEFINED_PORT = -1;
    private final Object pathToKeyStore;
    private final String password;
    private final String keyStoreType;
    private final int port;
    private final KeyStore trustStore;
    private final X509HostnameVerifier x509HostnameVerifier;
    private final boolean isUserConfigured;

    public SSLConfig keystore(String pathToJks, String password) {
        Validate.notNull((Object)pathToJks, (String)"Path to JKS on the file system cannot be null", (Object[])new Object[0]);
        Validate.notEmpty((CharSequence)password, (String)"Password cannot be empty", (Object[])new Object[0]);
        return new SSLConfig(pathToJks, password, this.keyStoreType, this.port, this.trustStore, this.x509HostnameVerifier, true);
    }

    public SSLConfig keystore(File pathToJks, String password) {
        Validate.notNull((Object)pathToJks, (String)"Path to JKS on the file system cannot be null", (Object[])new Object[0]);
        Validate.notEmpty((CharSequence)password, (String)"Password cannot be empty", (Object[])new Object[0]);
        return new SSLConfig(pathToJks, password, this.keyStoreType, this.port, this.trustStore, this.x509HostnameVerifier, true);
    }

    public SSLConfig keystore(String password) {
        Validate.notEmpty((CharSequence)password, (String)"Password cannot be empty", (Object[])new Object[0]);
        return this.keystore(System.getProperty("user.home") + File.separatorChar + ".keystore", password);
    }

    public SSLConfig() {
        this(null, null, KeyStore.getDefaultType(), -1, null, SSLSocketFactory.STRICT_HOSTNAME_VERIFIER, false);
    }

    private SSLConfig(Object pathToKeyStore, String password, String keyStoreType, int port, KeyStore trustStore, X509HostnameVerifier x509HostnameVerifier, boolean isUserConfigured) {
        AssertParameter.notNull((Object)keyStoreType, "Certificate type");
        AssertParameter.notNull((Object)x509HostnameVerifier, X509HostnameVerifier.class);
        this.pathToKeyStore = pathToKeyStore;
        this.password = password;
        this.keyStoreType = keyStoreType;
        this.port = port;
        this.trustStore = trustStore;
        this.x509HostnameVerifier = x509HostnameVerifier;
        this.isUserConfigured = isUserConfigured;
    }

    public SSLConfig keystoreType(String keystoreType) {
        return new SSLConfig(this.pathToKeyStore, this.password, keystoreType, this.port, this.trustStore, this.x509HostnameVerifier, true);
    }

    public SSLConfig port(int port) {
        return new SSLConfig(this.pathToKeyStore, this.password, this.keyStoreType, port, this.trustStore, this.x509HostnameVerifier, true);
    }

    public SSLConfig trustStore(KeyStore trustStore) {
        return new SSLConfig(this.pathToKeyStore, this.password, this.keyStoreType, this.port, trustStore, this.x509HostnameVerifier, true);
    }

    public SSLConfig x509HostnameVerifier(X509HostnameVerifier x509HostnameVerifier) {
        return new SSLConfig(this.pathToKeyStore, this.password, this.keyStoreType, this.port, this.trustStore, x509HostnameVerifier, true);
    }

    public SSLConfig strictHostnames() {
        return new SSLConfig(this.pathToKeyStore, this.password, this.keyStoreType, this.port, this.trustStore, SSLSocketFactory.STRICT_HOSTNAME_VERIFIER, true);
    }

    public SSLConfig allowAllHostnames() {
        return new SSLConfig(this.pathToKeyStore, this.password, this.keyStoreType, this.port, this.trustStore, SSLSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER, true);
    }

    public static SSLConfig sslConfig() {
        return new SSLConfig();
    }

    public SSLConfig and() {
        return this;
    }

    public SSLConfig with() {
        return this;
    }

    public SSLConfig using() {
        return this;
    }

    public Object getPathToKeyStore() {
        return this.pathToKeyStore;
    }

    public String getPassword() {
        return this.password;
    }

    public String getKeyStoreType() {
        return this.keyStoreType;
    }

    public int getPort() {
        return this.port;
    }

    public KeyStore getTrustStore() {
        return this.trustStore;
    }

    public X509HostnameVerifier getX509HostnameVerifier() {
        return this.x509HostnameVerifier;
    }

    public boolean isUserConfigured() {
        return this.isUserConfigured;
    }
}

