/*
 * Decompiled with CFR 0.152.
 */
package com.jayway.restassured;

import com.jayway.restassured.authentication.AuthenticationScheme;
import com.jayway.restassured.authentication.BasicAuthScheme;
import com.jayway.restassured.authentication.CertAuthScheme;
import com.jayway.restassured.authentication.CertificateAuthSettings;
import com.jayway.restassured.authentication.FormAuthConfig;
import com.jayway.restassured.authentication.FormAuthScheme;
import com.jayway.restassured.authentication.NoAuthScheme;
import com.jayway.restassured.authentication.OAuth2Scheme;
import com.jayway.restassured.authentication.OAuthScheme;
import com.jayway.restassured.authentication.OAuthSignature;
import com.jayway.restassured.authentication.PreemptiveAuthProvider;
import com.jayway.restassured.config.ObjectMapperConfig;
import com.jayway.restassured.config.RestAssuredConfig;
import com.jayway.restassured.config.SSLConfig;
import com.jayway.restassured.filter.Filter;
import com.jayway.restassured.http.ContentType;
import com.jayway.restassured.internal.RequestSpecificationImpl;
import com.jayway.restassured.internal.ResponseParserRegistrar;
import com.jayway.restassured.internal.ResponseSpecificationImpl;
import com.jayway.restassured.internal.TestSpecificationImpl;
import com.jayway.restassured.internal.assertion.AssertParameter;
import com.jayway.restassured.mapper.ObjectMapper;
import com.jayway.restassured.parsing.Parser;
import com.jayway.restassured.response.Response;
import com.jayway.restassured.specification.Argument;
import com.jayway.restassured.specification.RequestSender;
import com.jayway.restassured.specification.RequestSpecification;
import com.jayway.restassured.specification.ResponseSpecification;
import java.io.File;
import java.net.URI;
import java.net.URL;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RestAssured {
    private static ResponseParserRegistrar RESPONSE_PARSER_REGISTRAR = new ResponseParserRegistrar();
    public static final String DEFAULT_URI = "http://localhost";
    public static final String DEFAULT_BODY_ROOT_PATH = "";
    public static final int DEFAULT_PORT = 8080;
    public static final String DEFAULT_PATH = "";
    public static final AuthenticationScheme DEFAULT_AUTH = new NoAuthScheme();
    public static final boolean DEFAULT_URL_ENCODING_ENABLED = true;
    public static final String DEFAULT_SESSION_ID_VALUE = null;
    public static String baseURI = "http://localhost";
    public static int port = 8080;
    public static String basePath = "";
    public static boolean urlEncodingEnabled = true;
    public static AuthenticationScheme authentication = DEFAULT_AUTH;
    public static RestAssuredConfig config = new RestAssuredConfig();
    public static String rootPath = "";
    public static RequestSpecification requestSpecification = null;
    public static Parser defaultParser = null;
    public static ResponseSpecification responseSpecification = null;
    public static String sessionId = DEFAULT_SESSION_ID_VALUE;
    private static Object requestContentType = null;
    private static Object responseContentType = null;
    private static List<Filter> filters = new LinkedList<Filter>();

    public static void filters(List<Filter> filters) {
        Validate.notNull(filters, (String)"Filter list cannot be null", (Object[])new Object[0]);
        RestAssured.filters.addAll(filters);
    }

    public static void filters(Filter filter, Filter ... additionalFilters) {
        Validate.notNull((Object)filter, (String)"Filter cannot be null", (Object[])new Object[0]);
        filters.add(filter);
        if (additionalFilters != null) {
            Collections.addAll(filters, additionalFilters);
        }
    }

    public static List<Filter> filters() {
        return Collections.unmodifiableList(filters);
    }

    public static void objectMapper(ObjectMapper objectMapper) {
        Validate.notNull((Object)objectMapper, (String)"Default object mapper cannot be null", (Object[])new Object[0]);
        config = RestAssured.config().objectMapperConfig(ObjectMapperConfig.objectMapperConfig().defaultObjectMapper(objectMapper));
    }

    public static Object requestContentType() {
        return requestContentType;
    }

    public static Object responseContentType() {
        return responseContentType;
    }

    public static void requestContentType(ContentType contentType) {
        requestContentType = contentType;
    }

    public static void requestContentType(String contentType) {
        requestContentType = contentType;
    }

    public static void responseContentType(ContentType contentType) {
        responseContentType = contentType;
    }

    public static void responseContentType(String contentType) {
        responseContentType = contentType;
    }

    public static ResponseSpecification expect() {
        return RestAssured.createTestSpecification().getResponseSpecification();
    }

    public static RequestSpecification with() {
        return RestAssured.given();
    }

    public static List<Argument> withArguments(Object firstArgument, Object ... additionalArguments) {
        Validate.notNull((Object)firstArgument, (String)"You need to supply at least one argument", (Object[])new Object[0]);
        LinkedList<Argument> arguments = new LinkedList<Argument>();
        arguments.add(Argument.arg(firstArgument));
        if (additionalArguments != null && additionalArguments.length > 0) {
            for (Object additionalArgument : additionalArguments) {
                arguments.add(Argument.arg(additionalArgument));
            }
        }
        return Collections.unmodifiableList(arguments);
    }

    public static List<Argument> withNoArguments() {
        return Collections.unmodifiableList(Collections.emptyList());
    }

    public static List<Argument> withArgs(Object firstArgument, Object ... additionalArguments) {
        return RestAssured.withArguments(firstArgument, additionalArguments);
    }

    public static List<Argument> withNoArgs() {
        return RestAssured.withNoArguments();
    }

    public static RequestSpecification given() {
        return RestAssured.createTestSpecification().getRequestSpecification();
    }

    public static RequestSender when() {
        return RestAssured.createTestSpecification().getRequestSpecification();
    }

    public static RequestSender given(RequestSpecification requestSpecification, ResponseSpecification responseSpecification) {
        return new TestSpecificationImpl(requestSpecification, responseSpecification);
    }

    public static RequestSpecification given(RequestSpecification requestSpecification) {
        return RestAssured.given().spec(requestSpecification);
    }

    public static Response get(String path, Object ... pathParams) {
        return (Response)RestAssured.given().get(path, pathParams);
    }

    public static Response get(String path, Map<String, ?> pathParams) {
        return (Response)RestAssured.given().get(path, pathParams);
    }

    public static Response post(String path, Object ... pathParams) {
        return (Response)RestAssured.given().post(path, pathParams);
    }

    public static Response post(String path, Map<String, ?> pathParams) {
        return (Response)RestAssured.given().post(path, pathParams);
    }

    public static Response put(String path, Object ... pathParams) {
        return (Response)RestAssured.given().put(path, pathParams);
    }

    public static Response delete(String path, Object ... pathParams) {
        return (Response)RestAssured.given().delete(path, pathParams);
    }

    public static Response delete(String path, Map<String, ?> pathParams) {
        return (Response)RestAssured.given().delete(path, pathParams);
    }

    public static Response head(String path, Object ... pathParams) {
        return (Response)RestAssured.given().head(path, pathParams);
    }

    public static Response head(String path, Map<String, ?> pathParams) {
        return (Response)RestAssured.given().head(path, pathParams);
    }

    public static Response patch(String path, Object ... pathParams) {
        return (Response)RestAssured.given().patch(path, pathParams);
    }

    public static Response patch(String path, Map<String, ?> pathParams) {
        return (Response)RestAssured.given().patch(path, pathParams);
    }

    public static Response options(String path, Object ... pathParams) {
        return (Response)RestAssured.given().options(path, pathParams);
    }

    public static Response options(String path, Map<String, ?> pathParams) {
        return (Response)RestAssured.given().options(path, pathParams);
    }

    public static Response get(URI uri) {
        return (Response)RestAssured.given().get(uri);
    }

    public static Response post(URI uri) {
        return (Response)RestAssured.given().post(uri);
    }

    public static Response put(URI uri) {
        return (Response)RestAssured.given().put(uri);
    }

    public static Response delete(URI uri) {
        return (Response)RestAssured.given().delete(uri);
    }

    public static Response head(URI uri) {
        return (Response)RestAssured.given().head(uri);
    }

    public static Response patch(URI uri) {
        return (Response)RestAssured.given().patch(uri);
    }

    public static Response options(URI uri) {
        return (Response)RestAssured.given().options(uri);
    }

    public static Response get(URL url) {
        return (Response)RestAssured.given().get(url);
    }

    public static Response post(URL url) {
        return (Response)RestAssured.given().post(url);
    }

    public static Response put(URL url) {
        return (Response)RestAssured.given().put(url);
    }

    public static Response delete(URL url) {
        return (Response)RestAssured.given().delete(url);
    }

    public static Response head(URL url) {
        return (Response)RestAssured.given().head(url);
    }

    public static Response patch(URL url) {
        return (Response)RestAssured.given().patch(url);
    }

    public static Response options(URL url) {
        return (Response)RestAssured.given().options(url);
    }

    public static Response get() {
        return (Response)RestAssured.given().get();
    }

    public static Response post() {
        return (Response)RestAssured.given().post();
    }

    public static Response put() {
        return (Response)RestAssured.given().put();
    }

    public static Response delete() {
        return (Response)RestAssured.given().delete();
    }

    public static Response head() {
        return (Response)RestAssured.given().head();
    }

    public static Response patch() {
        return (Response)RestAssured.given().patch();
    }

    public static Response options() {
        return (Response)RestAssured.given().options();
    }

    public static AuthenticationScheme basic(String userName, String password) {
        BasicAuthScheme scheme = new BasicAuthScheme();
        scheme.setUserName(userName);
        scheme.setPassword(password);
        return scheme;
    }

    public static AuthenticationScheme form(String userName, String password) {
        return RestAssured.form(userName, password, null);
    }

    public static AuthenticationScheme form(String userName, String password, FormAuthConfig config) {
        if (userName == null) {
            throw new IllegalArgumentException("Username cannot be null");
        }
        if (password == null) {
            throw new IllegalArgumentException("Password cannot be null");
        }
        FormAuthScheme scheme = new FormAuthScheme();
        scheme.setUserName(userName);
        scheme.setPassword(password);
        scheme.setConfig(config);
        return scheme;
    }

    public static PreemptiveAuthProvider preemptive() {
        return new PreemptiveAuthProvider();
    }

    public static AuthenticationScheme certificate(String certURL, String password) {
        SSLConfig sslConfig = RestAssured.config().getSSLConfig();
        return RestAssured.certificate(certURL, password, CertificateAuthSettings.certAuthSettings().keystoreType(sslConfig.getKeyStoreType()).trustStore(sslConfig.getTrustStore()).x509HostnameVerifier(sslConfig.getX509HostnameVerifier()).port(sslConfig.getPort()));
    }

    public static AuthenticationScheme certificate(String certURL, String password, CertificateAuthSettings certificateAuthSettings) {
        AssertParameter.notNull((Object)certURL, "Certificate URL");
        AssertParameter.notNull((Object)password, "Certificate password");
        AssertParameter.notNull((Object)certificateAuthSettings, CertificateAuthSettings.class);
        CertAuthScheme scheme = new CertAuthScheme();
        scheme.setPathToKeyStore(certURL);
        scheme.setPassword(password);
        scheme.setKeystoreType(certificateAuthSettings.getKeystoreType());
        scheme.setPort(certificateAuthSettings.getPort());
        scheme.setTrustStore(certificateAuthSettings.getTrustStore());
        scheme.setX509HostnameVerifier(certificateAuthSettings.getX509HostnameVerifier());
        return scheme;
    }

    @Deprecated
    public static AuthenticationScheme certificate(String certURL, String password, String keystoreType, int port) {
        return RestAssured.certificate(certURL, password, CertificateAuthSettings.certAuthSettings().keystoreType(keystoreType).port(port));
    }

    public static AuthenticationScheme digest(String userName, String password) {
        return RestAssured.basic(userName, password);
    }

    public static AuthenticationScheme oauth(String consumerKey, String consumerSecret, String accessToken, String secretToken) {
        OAuthScheme scheme = new OAuthScheme();
        scheme.setConsumerKey(consumerKey);
        scheme.setConsumerSecret(consumerSecret);
        scheme.setAccessToken(accessToken);
        scheme.setSecretToken(secretToken);
        return scheme;
    }

    public static AuthenticationScheme oauth(String consumerKey, String consumerSecret, String accessToken, String secretToken, OAuthSignature signature) {
        OAuthScheme scheme = new OAuthScheme();
        scheme.setConsumerKey(consumerKey);
        scheme.setConsumerSecret(consumerSecret);
        scheme.setAccessToken(accessToken);
        scheme.setSecretToken(secretToken);
        scheme.setSignature(signature);
        return scheme;
    }

    public static AuthenticationScheme oauth2(String accessToken) {
        OAuth2Scheme scheme = new OAuth2Scheme();
        scheme.setAccessToken(accessToken);
        return scheme;
    }

    public static AuthenticationScheme oauth2(String accessToken, OAuthSignature signature) {
        OAuth2Scheme scheme = new OAuth2Scheme();
        scheme.setAccessToken(accessToken);
        scheme.setSignature(signature);
        return scheme;
    }

    public static void registerParser(String contentType, Parser parser) {
        RESPONSE_PARSER_REGISTRAR.registerParser(contentType, parser);
    }

    public static void unregisterParser(String contentType) {
        RESPONSE_PARSER_REGISTRAR.unregisterParser(contentType);
    }

    public static void reset() {
        baseURI = DEFAULT_URI;
        port = 8080;
        basePath = "";
        authentication = DEFAULT_AUTH;
        rootPath = "";
        filters = new LinkedList<Filter>();
        requestContentType = null;
        responseContentType = null;
        requestSpecification = null;
        responseSpecification = null;
        urlEncodingEnabled = true;
        RESPONSE_PARSER_REGISTRAR = new ResponseParserRegistrar();
        defaultParser = null;
        config = new RestAssuredConfig();
        sessionId = DEFAULT_SESSION_ID_VALUE;
    }

    private static TestSpecificationImpl createTestSpecification() {
        if (defaultParser != null) {
            RESPONSE_PARSER_REGISTRAR.registerDefaultParser(defaultParser);
        }
        ResponseParserRegistrar responseParserRegistrar = new ResponseParserRegistrar(RESPONSE_PARSER_REGISTRAR);
        RestAssured.applySessionIdIfApplicable();
        return new TestSpecificationImpl(new RequestSpecificationImpl(baseURI, port, basePath, authentication, filters, requestContentType, requestSpecification, urlEncodingEnabled, config), new ResponseSpecificationImpl(rootPath, responseContentType, responseSpecification, responseParserRegistrar, RestAssured.config()));
    }

    private static void applySessionIdIfApplicable() {
        if (!StringUtils.equals((CharSequence)sessionId, (CharSequence)DEFAULT_SESSION_ID_VALUE)) {
            RestAssuredConfig configToUse = config == null ? new RestAssuredConfig() : config;
            config = configToUse.sessionConfig(configToUse.getSessionConfig().sessionIdValue(sessionId));
        }
    }

    public static void keystore(String pathToJks, String password) {
        Validate.notEmpty((CharSequence)password, (String)"Password cannot be empty", (Object[])new Object[0]);
        RestAssured.applyKeyStore(pathToJks, password);
    }

    public static void keystore(File pathToJks, String password) {
        Validate.notNull((Object)pathToJks, (String)"Path to JKS on the file system cannot be null", (Object[])new Object[0]);
        RestAssured.applyKeyStore(pathToJks, password);
    }

    public static void keystore(String password) {
        RestAssured.applyKeyStore(null, password);
    }

    private static void applyKeyStore(Object pathToJks, String password) {
        RestAssuredConfig restAssuredConfig = RestAssured.config();
        SSLConfig updatedSSLConfig = pathToJks instanceof File ? restAssuredConfig.getSSLConfig().keystore((File)pathToJks, password) : restAssuredConfig.getSSLConfig().keystore((String)pathToJks, password);
        config = RestAssured.config().sslConfig(updatedSSLConfig.allowAllHostnames());
    }

    public static RestAssuredConfig config() {
        return config == null ? new RestAssuredConfig() : config;
    }
}

