/*
 * Decompiled with CFR 0.152.
 */
package com.jayway.restassured.module.jsv;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.fge.jackson.JsonLoader;
import com.github.fge.jsonschema.main.JsonSchema;
import com.github.fge.jsonschema.main.JsonSchemaFactory;
import com.github.fge.jsonschema.report.ProcessingMessage;
import com.github.fge.jsonschema.report.ProcessingReport;
import com.google.common.collect.Lists;
import com.jayway.restassured.module.jsv.JsonSchemaValidationException;
import com.jayway.restassured.module.jsv.JsonSchemaValidatorSettings;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JsonSchemaValidator
extends TypeSafeMatcher<String> {
    public static JsonSchemaValidatorSettings settings;
    private final JsonNode schema;
    private final JsonSchemaValidatorSettings instanceSettings;
    private ProcessingReport report;

    private JsonSchemaValidator(JsonNode schema, JsonSchemaValidatorSettings jsonSchemaValidatorSettings) {
        if (jsonSchemaValidatorSettings == null) {
            throw new IllegalArgumentException(JsonSchemaValidatorSettings.class.getSimpleName() + " cannot be null.");
        }
        this.schema = schema;
        this.instanceSettings = jsonSchemaValidatorSettings;
    }

    public static JsonSchemaValidator matchesJsonSchema(String schema) {
        return new JsonSchemaValidatorFactory<String>(){

            @Override
            JsonNode createJsonNodeInstance(String schema) throws IOException {
                return JsonLoader.fromString((String)schema);
            }
        }.create(schema);
    }

    public static JsonSchemaValidator matchesJsonSchemaInClasspath(String pathToSchemaInClasspath) {
        return JsonSchemaValidator.matchesJsonSchema(Thread.currentThread().getContextClassLoader().getResource(pathToSchemaInClasspath));
    }

    public static JsonSchemaValidator matchesJsonSchema(InputStream schema) {
        return JsonSchemaValidator.matchesJsonSchema(new InputStreamReader(schema));
    }

    public static JsonSchemaValidator matchesJsonSchema(Reader schema) {
        return new JsonSchemaValidatorFactory<Reader>(){

            @Override
            JsonNode createJsonNodeInstance(Reader schema) throws IOException {
                return JsonLoader.fromReader((Reader)schema);
            }
        }.create(schema);
    }

    public static JsonSchemaValidator matchesJsonSchema(File file) {
        return new JsonSchemaValidatorFactory<File>(){

            @Override
            JsonNode createJsonNodeInstance(File schema) throws IOException {
                return JsonLoader.fromFile((File)schema);
            }
        }.create(file);
    }

    public static JsonSchemaValidator matchesJsonSchema(URL url) {
        return new JsonSchemaValidatorFactory<URL>(){

            @Override
            JsonNode createJsonNodeInstance(URL schema) throws IOException {
                return JsonLoader.fromURL((URL)schema);
            }
        }.create(url);
    }

    public static JsonSchemaValidator matchesJsonSchema(URI uri) {
        return JsonSchemaValidator.matchesJsonSchema(JsonSchemaValidator.toURL(uri));
    }

    public Matcher<?> using(JsonSchemaFactory jsonSchemaFactory) {
        return new JsonSchemaValidator(this.schema, this.instanceSettings.jsonSchemaFactory(jsonSchemaFactory));
    }

    public Matcher<?> using(JsonSchemaValidatorSettings jsonSchemaValidatorSettings) {
        return new JsonSchemaValidator(this.schema, jsonSchemaValidatorSettings);
    }

    private static URL toURL(URI uri) {
        JsonSchemaValidator.validateSchemaIsNotNull(uri);
        try {
            return uri.toURL();
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("Can't convert the supplied URI to a URL", e);
        }
    }

    protected boolean matchesSafely(String content) {
        try {
            JsonNode contentAsJsonNode = JsonLoader.fromString((String)content);
            JsonSchema jsonSchema = this.instanceSettings.jsonSchemaFactory().getJsonSchema(this.schema);
            this.report = this.instanceSettings.shouldUseCheckedValidation() ? jsonSchema.validate(contentAsJsonNode) : jsonSchema.validateUnchecked(contentAsJsonNode);
            return this.report.isSuccess();
        }
        catch (Exception e) {
            throw new JsonSchemaValidationException(e);
        }
    }

    public void describeTo(Description description) {
        if (this.report != null) {
            description.appendText("The content to match the given JSON schema.\n");
            ArrayList messages = Lists.newArrayList((Iterable)this.report);
            if (!messages.isEmpty()) {
                for (ProcessingMessage message : messages) {
                    description.appendText(message.toString());
                }
            }
        }
    }

    private static void validateSchemaIsNotNull(Object schema) {
        if (schema == null) {
            throw new IllegalArgumentException("Schema to use cannot be null");
        }
    }

    public static void reset() {
        settings = null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class JsonSchemaValidatorFactory<T> {
        private JsonSchemaValidatorFactory() {
        }

        private JsonSchemaValidatorSettings createSettings() {
            return settings == null ? new JsonSchemaValidatorSettings() : settings;
        }

        public JsonSchemaValidator create(T schema) {
            JsonNode schemaNode;
            JsonSchemaValidator.validateSchemaIsNotNull(schema);
            try {
                schemaNode = this.createJsonNodeInstance(schema);
            }
            catch (IOException e) {
                throw new JsonSchemaValidationException(e);
            }
            return new JsonSchemaValidator(schemaNode, this.createSettings());
        }

        abstract JsonNode createJsonNodeInstance(T var1) throws IOException;
    }
}

