/*
 * Decompiled with CFR 0.152.
 */
package com.jayway.jsonpath.filter;

import com.jayway.jsonpath.InvalidPathException;
import com.jayway.jsonpath.filter.JsonPathFilterBase;
import com.jayway.jsonpath.filter.JsonPathFilterFactory;
import java.util.LinkedList;
import java.util.List;
import org.json.simple.JSONArray;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JsonPathFilterChain {
    private List<JsonPathFilterBase> filters;

    public JsonPathFilterChain(List<String> pathFragments) {
        this.filters = this.configureFilters(pathFragments);
    }

    private List<JsonPathFilterBase> configureFilters(List<String> pathFragments) {
        LinkedList<JsonPathFilterBase> configured = new LinkedList<JsonPathFilterBase>();
        for (String pathFragment : pathFragments) {
            configured.add(JsonPathFilterFactory.createFilter(pathFragment));
        }
        return configured;
    }

    public List<Object> filter(Object root) {
        JSONArray rootList = new JSONArray();
        rootList.add(root);
        Object result = rootList;
        for (JsonPathFilterBase filter : this.filters) {
            if (filter == null) {
                throw new InvalidPathException();
            }
            result = filter.apply((List<Object>)result);
        }
        return result;
    }
}

