/*
 * Decompiled with CFR 0.152.
 */
package com.javaetmoi.core.persistence.hibernate;

import com.javaetmoi.core.persistence.hibernate.ReflectionUtil;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javassist.util.proxy.ProxyObject;
import org.hibernate.Hibernate;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.collection.internal.PersistentMap;
import org.hibernate.collection.spi.PersistentCollection;
import org.hibernate.internal.util.collections.IdentitySet;
import org.hibernate.metadata.ClassMetadata;
import org.hibernate.proxy.HibernateProxy;
import org.hibernate.type.ComponentType;
import org.hibernate.type.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LazyLoadingUtil {
    private LazyLoadingUtil() {
    }

    public static <E> Collection<E> deepHydrate(Session currentSession, Collection<E> entities) {
        IdentitySet recursiveGuard = new IdentitySet();
        for (E entity : entities) {
            LazyLoadingUtil.deepInflateEntity(currentSession, entity, recursiveGuard);
        }
        return entities;
    }

    public static <E> E deepHydrate(Session currentSession, E entity) {
        IdentitySet recursiveGuard = new IdentitySet();
        LazyLoadingUtil.deepInflateEntity(currentSession, entity, recursiveGuard);
        return entity;
    }

    private static void deepInflateEntity(Session currentSession, Object entity, IdentitySet recursiveGuard) throws HibernateException {
        if (entity == null || !recursiveGuard.add(entity)) {
            return;
        }
        Class persistentClass = entity instanceof HibernateProxy ? ((HibernateProxy)entity).getHibernateLazyInitializer().getPersistentClass() : entity.getClass();
        ClassMetadata classMetadata = currentSession.getSessionFactory().getClassMetadata(persistentClass);
        if (classMetadata == null) {
            return;
        }
        if (!Hibernate.isInitialized((Object)entity)) {
            Hibernate.initialize((Object)entity);
        }
        String[] propertyNames = classMetadata.getPropertyNames();
        Type[] propertyTypes = classMetadata.getPropertyTypes();
        int n = propertyNames.length;
        for (int i = 0; i < n; ++i) {
            String propertyName = propertyNames[i];
            Type propertyType = propertyTypes[i];
            Object propertyValue = entity instanceof ProxyObject ? LazyLoadingUtil.callCollectionGetter(entity, propertyName) : classMetadata.getPropertyValue(entity, propertyName);
            LazyLoadingUtil.deepInflateProperty(propertyValue, propertyType, currentSession, recursiveGuard);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void deepInflateProperty(Object propertyValue, Type propertyType, Session currentSession, IdentitySet recursiveGuard) {
        if (propertyValue == null) {
            return;
        }
        if (propertyType.isEntityType()) {
            LazyLoadingUtil.deepInflateEntity(currentSession, propertyValue, recursiveGuard);
            return;
        } else if (propertyType.isCollectionType()) {
            if (propertyValue instanceof List) {
                LazyLoadingUtil.deepInflateCollection(currentSession, recursiveGuard, (List)propertyValue);
                return;
            } else if (propertyValue instanceof Map) {
                LazyLoadingUtil.deepInflateMap(currentSession, recursiveGuard, (Map)propertyValue);
                return;
            } else {
                if (!(propertyValue instanceof Set)) throw new UnsupportedOperationException("Unsupported collection type: " + propertyValue.getClass().getSimpleName());
                LazyLoadingUtil.deepInflateCollection(currentSession, recursiveGuard, (Set)propertyValue);
            }
            return;
        } else {
            if (!propertyType.isComponentType() || !(propertyType instanceof ComponentType)) return;
            LazyLoadingUtil.deepInflateComponent(currentSession, propertyValue, (ComponentType)propertyType, recursiveGuard);
        }
    }

    private static void deepInflateComponent(Session currentSession, Object componentValue, ComponentType componentType, IdentitySet recursiveGuard) {
        if (componentValue == null || !recursiveGuard.add(componentValue)) {
            return;
        }
        String[] propertyNames = (String[])ReflectionUtil.getValue("propertyNames", componentType);
        Type[] propertyTypes = (Type[])ReflectionUtil.getValue("propertyTypes", componentType);
        for (int i = 0; i < propertyNames.length; ++i) {
            String propertyName = propertyNames[i];
            Type propertyType = propertyTypes[i];
            Object propertyValue = ReflectionUtil.getValue(propertyName, componentValue);
            LazyLoadingUtil.deepInflateProperty(propertyValue, propertyType, currentSession, recursiveGuard);
        }
    }

    private static void deepInflateMap(Session currentSession, IdentitySet recursiveGuard, Map map) {
        if (map == null || !recursiveGuard.add((Object)map)) {
            return;
        }
        if (map instanceof PersistentMap && !((PersistentMap)map).wasInitialized()) {
            Hibernate.initialize((Object)map);
        }
        if (map.size() > 0) {
            Set keySet = map.keySet();
            for (Object key : keySet) {
                LazyLoadingUtil.deepInflateEntity(currentSession, key, recursiveGuard);
            }
            LazyLoadingUtil.deepInflateCollection(currentSession, recursiveGuard, map.values());
        }
    }

    private static void deepInflateCollection(Session currentSession, IdentitySet recursiveGuard, Collection collection) {
        if (collection == null || !recursiveGuard.add((Object)collection)) {
            return;
        }
        if (collection.size() > 0) {
            ComponentType collectionType = null;
            if (collection instanceof PersistentCollection && !((PersistentCollection)collection).isUnreferenced()) {
                String role = ((PersistentCollection)collection).getRole();
                Type type = currentSession.getSessionFactory().getCollectionMetadata(role).getElementType();
                if (type instanceof ComponentType) {
                    collectionType = (ComponentType)type;
                }
            }
            for (Object item : collection) {
                if (item == null) continue;
                if (collectionType != null) {
                    LazyLoadingUtil.deepInflateComponent(currentSession, item, collectionType, recursiveGuard);
                    continue;
                }
                LazyLoadingUtil.deepInflateEntity(currentSession, item, recursiveGuard);
            }
        }
    }

    protected static Object callCollectionGetter(Object entity, String propertyName) {
        try {
            Method getter = entity.getClass().getMethod(LazyLoadingUtil.getterFromCollection(propertyName), new Class[0]);
            getter.setAccessible(true);
            return getter.invoke(entity, new Object[0]);
        }
        catch (NoSuchMethodException e) {
            return new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            return new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            return new RuntimeException(e);
        }
    }

    protected static String getterFromCollection(String propertyName) {
        return "get" + Character.toTitleCase(propertyName.charAt(0)) + propertyName.substring(1);
    }
}

