/*
 * Decompiled with CFR 0.152.
 */
package com.javadocmd.simplelatlng.window;

import com.javadocmd.simplelatlng.LatLng;
import com.javadocmd.simplelatlng.LatLngTool;
import com.javadocmd.simplelatlng.util.LatLngConfig;
import com.javadocmd.simplelatlng.util.LengthUnit;
import com.javadocmd.simplelatlng.window.FilterHelper;
import com.javadocmd.simplelatlng.window.LatLngWindow;
import com.javadocmd.simplelatlng.window.SortWrapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;

public class CircularWindow
extends LatLngWindow<CircularWindow> {
    private LatLng center;
    private long radius;

    public CircularWindow(LatLng center, double radiusInDegrees) {
        this.setCenter(center);
        this.setRadius(radiusInDegrees);
    }

    public CircularWindow(LatLng center, double radius, LengthUnit unit) {
        this.setCenter(center);
        this.setRadius(LatLngWindow.lengthToLatitudeDelta(radius, unit));
    }

    public <E> void filterCopySort(Collection<E> source, Collection<E> destination, FilterHelper<E> helper) {
        ArrayList<SortWrapper<E>> sortList = new ArrayList<SortWrapper<E>>();
        for (E e : source) {
            Double distance = this.containsForSort(helper.getLatLng(e));
            if (distance == null) continue;
            sortList.add(new SortWrapper<E>(e, distance));
        }
        Collections.sort(sortList, new SortWrapper.DistanceComparator());
        for (SortWrapper sortWrapper : sortList) {
            destination.add(sortWrapper.getValue());
        }
    }

    private Double containsForSort(LatLng point) {
        double d = Math.toDegrees(LatLngTool.distanceInRadians(this.center, point));
        if (LatLngConfig.doubleToLong(d) <= this.radius) {
            return d;
        }
        return null;
    }

    @Override
    public boolean contains(LatLng point) {
        return LatLngConfig.doubleToLong(Math.toDegrees(LatLngTool.distanceInRadians(this.center, point))) <= this.radius;
    }

    @Override
    public boolean overlaps(CircularWindow window) {
        long angle = LatLngConfig.doubleToLong(Math.toDegrees(LatLngTool.distanceInRadians(this.center, window.getCenter())));
        return angle <= this.radius + window.radius;
    }

    @Override
    public LatLng getCenter() {
        return this.center;
    }

    public void setCenter(LatLng center) {
        if (center == null) {
            throw new IllegalArgumentException("Window's center may not be null.");
        }
        this.center = center;
    }

    public double getRadius() {
        return LatLngConfig.longToDouble(this.radius);
    }

    public double getRadius(LengthUnit unit) {
        return LatLngWindow.latitudeDeltaToLength(LatLngConfig.longToDouble(this.radius), unit);
    }

    public void setRadius(double radius) {
        if (Double.isNaN(radius)) {
            throw new IllegalArgumentException("Invalid radius given.");
        }
        this.radius = LatLngConfig.doubleToLong(Math.min(Math.abs(radius), 360.0));
    }

    public String toString() {
        return String.format("center: %s; radius: %s degrees", this.getCenter().toString(), LatLngConfig.DEGREE_FORMAT.format(this.getRadius()));
    }
}

