/*
 * Decompiled with CFR 0.152.
 */
package com.javadocmd.simplelatlng;

import com.javadocmd.simplelatlng.LatLngTool;
import com.javadocmd.simplelatlng.util.LatLngConfig;
import java.io.Serializable;
import java.util.Random;

public class LatLng
implements Serializable {
    private static final long serialVersionUID = 7086953744720769418L;
    private long latitude;
    private long longitude;

    public static LatLng random() {
        return LatLng.random(new Random());
    }

    public static LatLng random(Random r) {
        return new LatLng(r.nextDouble() * -180.0 + 90.0, r.nextDouble() * -360.0 + 180.0);
    }

    public static boolean degreesEqual(double degree1, double degree2) {
        if (Double.isNaN(degree1) || Double.isNaN(degree2)) {
            return false;
        }
        if (Double.isInfinite(degree1) || Double.isInfinite(degree2)) {
            return false;
        }
        return LatLngConfig.doubleToLong(degree1) == LatLngConfig.doubleToLong(degree2);
    }

    public LatLng(double latitude, double longitude) {
        this.setLatitudeLongitude(latitude, longitude);
    }

    public double getLatitude() {
        return LatLngConfig.longToDouble(this.latitude);
    }

    public long getLatitudeInternal() {
        return this.latitude;
    }

    public double getLongitude() {
        return LatLngConfig.longToDouble(this.longitude);
    }

    public long getLongitudeInternal() {
        return this.longitude;
    }

    public void setLatitudeLongitude(double latitude, double longitude) {
        this.setLatitude(latitude);
        if (Math.abs(this.latitude) == 90000000L) {
            this.setLongitude(0.0);
        } else {
            this.setLongitude(longitude);
        }
    }

    private void setLatitude(double latitude) {
        double lat = LatLngTool.normalizeLatitude(latitude);
        if (Double.isNaN(lat)) {
            throw new IllegalArgumentException("Invalid latitude given.");
        }
        this.latitude = LatLngConfig.doubleToLong(lat);
    }

    private void setLongitude(double longitude) {
        double lng = LatLngTool.normalizeLongitude(longitude);
        if (Double.isNaN(lng)) {
            throw new IllegalArgumentException("Invalid longitude given.");
        }
        this.longitude = LatLngConfig.doubleToLong(lng);
    }

    public boolean isPolar() {
        return this.latitude == 90000000L || this.latitude == -90000000L;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof LatLng)) {
            return false;
        }
        LatLng latlng = (LatLng)obj;
        if (this.latitude != latlng.latitude) {
            return false;
        }
        return this.longitude == latlng.longitude;
    }

    public int hashCode() {
        String s = Long.toString(this.latitude) + "|" + Long.toString(this.longitude);
        return s.hashCode();
    }

    public String toString() {
        return String.format("(%s,%s)", LatLngConfig.DEGREE_FORMAT.format(LatLngConfig.longToDouble(this.latitude)), LatLngConfig.DEGREE_FORMAT.format(LatLngConfig.longToDouble(this.longitude)));
    }
}

