/*
 * Decompiled with CFR 0.152.
 */
package com.jaredrummler.materialspinner;

import android.animation.ObjectAnimator;
import android.app.Activity;
import android.content.Context;
import android.content.ContextWrapper;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.PorterDuff;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.StateListDrawable;
import android.os.Build;
import android.os.Bundle;
import android.os.Parcelable;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.util.Log;
import android.view.MotionEvent;
import android.view.View;
import android.widget.AdapterView;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.PopupWindow;
import android.widget.TextView;
import androidx.annotation.ColorInt;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.jaredrummler.materialspinner.MaterialSpinnerAdapter;
import com.jaredrummler.materialspinner.MaterialSpinnerAdapterWrapper;
import com.jaredrummler.materialspinner.MaterialSpinnerBaseAdapter;
import com.jaredrummler.materialspinner.R;
import com.jaredrummler.materialspinner.Utils;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;

public class MaterialSpinner
extends TextView {
    private OnNothingSelectedListener onNothingSelectedListener;
    private OnItemSelectedListener onItemSelectedListener;
    private MaterialSpinnerBaseAdapter adapter;
    private PopupWindow popupWindow;
    private ListView listView;
    private Drawable arrowDrawable;
    private boolean hideArrow;
    private boolean nothingSelected;
    private int popupWindowMaxHeight;
    private int popupWindowHeight;
    private int selectedIndex;
    private int backgroundColor;
    private int backgroundSelector;
    private int arrowColor;
    private int arrowColorDisabled;
    private int textColor;
    private int hintColor;
    private int popupPaddingTop;
    private int popupPaddingLeft;
    private int popupPaddingBottom;
    private int popupPaddingRight;
    private String hintText;

    public MaterialSpinner(Context context) {
        super(context);
        this.init(context, null);
    }

    public MaterialSpinner(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs);
    }

    public MaterialSpinner(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init(Context context, AttributeSet attrs) {
        int paddingRight;
        int paddingBottom;
        int paddingLeft;
        int paddingTop;
        int defaultPopupPaddingBottom;
        int defaultPopupPaddingRight;
        int defaultPaddingTop;
        TypedArray ta = context.obtainStyledAttributes(attrs, R.styleable.MaterialSpinner);
        int defaultColor = this.getTextColors().getDefaultColor();
        boolean rtl = Utils.isRtl(context);
        Resources resources = this.getResources();
        int defaultPaddingBottom = defaultPaddingTop = resources.getDimensionPixelSize(R.dimen.ms__padding_top);
        int defaultPaddingRight = defaultPaddingTop;
        int defaultPaddingLeft = defaultPaddingTop;
        if (rtl) {
            defaultPaddingRight = resources.getDimensionPixelSize(R.dimen.ms__padding_left);
        } else {
            defaultPaddingLeft = resources.getDimensionPixelSize(R.dimen.ms__padding_left);
        }
        int defaultPopupPaddingLeft = defaultPopupPaddingRight = resources.getDimensionPixelSize(R.dimen.ms__popup_padding_left);
        int defaultPopupPaddingTop = defaultPopupPaddingBottom = resources.getDimensionPixelSize(R.dimen.ms__popup_padding_top);
        try {
            this.backgroundColor = ta.getColor(R.styleable.MaterialSpinner_ms_background_color, -1);
            this.backgroundSelector = ta.getResourceId(R.styleable.MaterialSpinner_ms_background_selector, 0);
            this.textColor = ta.getColor(R.styleable.MaterialSpinner_ms_text_color, defaultColor);
            this.hintColor = ta.getColor(R.styleable.MaterialSpinner_ms_hint_color, defaultColor);
            this.arrowColor = ta.getColor(R.styleable.MaterialSpinner_ms_arrow_tint, this.textColor);
            this.hideArrow = ta.getBoolean(R.styleable.MaterialSpinner_ms_hide_arrow, false);
            this.hintText = ta.getString(R.styleable.MaterialSpinner_ms_hint) == null ? "" : ta.getString(R.styleable.MaterialSpinner_ms_hint);
            this.popupWindowMaxHeight = ta.getDimensionPixelSize(R.styleable.MaterialSpinner_ms_dropdown_max_height, 0);
            this.popupWindowHeight = ta.getLayoutDimension(R.styleable.MaterialSpinner_ms_dropdown_height, -2);
            paddingTop = ta.getDimensionPixelSize(R.styleable.MaterialSpinner_ms_padding_top, defaultPaddingTop);
            paddingLeft = ta.getDimensionPixelSize(R.styleable.MaterialSpinner_ms_padding_left, defaultPaddingLeft);
            paddingBottom = ta.getDimensionPixelSize(R.styleable.MaterialSpinner_ms_padding_bottom, defaultPaddingBottom);
            paddingRight = ta.getDimensionPixelSize(R.styleable.MaterialSpinner_ms_padding_right, defaultPaddingRight);
            this.popupPaddingTop = ta.getDimensionPixelSize(R.styleable.MaterialSpinner_ms_popup_padding_top, defaultPopupPaddingTop);
            this.popupPaddingLeft = ta.getDimensionPixelSize(R.styleable.MaterialSpinner_ms_popup_padding_left, defaultPopupPaddingLeft);
            this.popupPaddingBottom = ta.getDimensionPixelSize(R.styleable.MaterialSpinner_ms_popup_padding_bottom, defaultPopupPaddingBottom);
            this.popupPaddingRight = ta.getDimensionPixelSize(R.styleable.MaterialSpinner_ms_popup_padding_right, defaultPopupPaddingRight);
            this.arrowColorDisabled = Utils.lighter(this.arrowColor, 0.8f);
        }
        finally {
            ta.recycle();
        }
        this.nothingSelected = true;
        this.setGravity(8388627);
        this.setClickable(true);
        this.setPadding(paddingLeft, paddingTop, paddingRight, paddingBottom);
        this.setBackgroundResource(R.drawable.ms__selector);
        if (Build.VERSION.SDK_INT >= 17 && rtl) {
            this.setLayoutDirection(1);
            this.setTextDirection(4);
        }
        if (!this.hideArrow) {
            this.arrowDrawable = Utils.getDrawable(context, R.drawable.ms__arrow).mutate();
            this.arrowDrawable.setColorFilter(this.arrowColor, PorterDuff.Mode.SRC_IN);
            if (rtl) {
                this.setCompoundDrawablesWithIntrinsicBounds(this.arrowDrawable, null, null, null);
            } else {
                this.setCompoundDrawablesWithIntrinsicBounds(null, null, this.arrowDrawable, null);
            }
        }
        this.listView = new ListView(context);
        this.listView.setId(this.getId());
        this.listView.setDivider(null);
        this.listView.setItemsCanFocus(true);
        this.listView.setOnItemClickListener(new AdapterView.OnItemClickListener(){

            public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
                if (position >= MaterialSpinner.this.selectedIndex && position < MaterialSpinner.this.adapter.getCount() && MaterialSpinner.this.adapter.getItems().size() != 1 && TextUtils.isEmpty((CharSequence)MaterialSpinner.this.hintText)) {
                    ++position;
                }
                MaterialSpinner.this.selectedIndex = position;
                MaterialSpinner.this.nothingSelected = false;
                Object item = MaterialSpinner.this.adapter.get(position);
                MaterialSpinner.this.adapter.notifyItemSelected(position);
                MaterialSpinner.this.setTextColor(MaterialSpinner.this.textColor);
                MaterialSpinner.this.setText(item.toString());
                MaterialSpinner.this.collapse();
                if (MaterialSpinner.this.onItemSelectedListener != null) {
                    MaterialSpinner.this.onItemSelectedListener.onItemSelected(MaterialSpinner.this, position, id2, item);
                }
            }
        });
        this.popupWindow = new PopupWindow(context);
        this.popupWindow.setContentView((View)this.listView);
        this.popupWindow.setOutsideTouchable(true);
        this.popupWindow.setFocusable(true);
        if (Build.VERSION.SDK_INT >= 21) {
            this.popupWindow.setElevation(16.0f);
            this.popupWindow.setBackgroundDrawable(Utils.getDrawable(context, R.drawable.ms__drawable));
        } else {
            this.popupWindow.setBackgroundDrawable(Utils.getDrawable(context, R.drawable.ms__drop_down_shadow));
        }
        if (this.backgroundColor != -1) {
            this.setBackgroundColor(this.backgroundColor);
        } else if (this.backgroundSelector != 0) {
            this.setBackgroundResource(this.backgroundSelector);
        }
        if (this.textColor != defaultColor) {
            this.setTextColor(this.textColor);
        }
        this.popupWindow.setOnDismissListener(new PopupWindow.OnDismissListener(){

            public void onDismiss() {
                if (MaterialSpinner.this.nothingSelected && MaterialSpinner.this.onNothingSelectedListener != null) {
                    MaterialSpinner.this.onNothingSelectedListener.onNothingSelected(MaterialSpinner.this);
                }
                if (!MaterialSpinner.this.hideArrow) {
                    MaterialSpinner.this.animateArrow(false);
                }
            }
        });
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        this.popupWindow.setWidth(View.MeasureSpec.getSize((int)widthMeasureSpec));
        this.popupWindow.setHeight(this.calculatePopupWindowHeight());
        if (this.adapter != null) {
            CharSequence currentText = this.getText();
            String longestItem = currentText.toString();
            for (int i = 0; i < this.adapter.getCount(); ++i) {
                String itemText = this.adapter.getItemText(i);
                if (itemText.length() <= longestItem.length()) continue;
                longestItem = itemText;
            }
            this.setText(longestItem);
            super.onMeasure(widthMeasureSpec, heightMeasureSpec);
            this.setText(currentText);
        } else {
            super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        }
    }

    public boolean onTouchEvent(@NonNull MotionEvent event) {
        if (event.getAction() == 1 && this.isEnabled() && this.isClickable()) {
            if (!this.popupWindow.isShowing()) {
                this.expand();
            } else {
                this.collapse();
            }
        }
        return super.onTouchEvent(event);
    }

    public void setBackgroundColor(int color) {
        this.backgroundColor = color;
        Drawable background = this.getBackground();
        if (background instanceof StateListDrawable) {
            try {
                Method getStateDrawable = StateListDrawable.class.getDeclaredMethod("getStateDrawable", Integer.TYPE);
                if (!getStateDrawable.isAccessible()) {
                    getStateDrawable.setAccessible(true);
                }
                int[] colors = new int[]{Utils.darker(color, 0.85f), color};
                for (int i = 0; i < colors.length; ++i) {
                    ColorDrawable drawable2 = (ColorDrawable)getStateDrawable.invoke((Object)background, i);
                    drawable2.setColor(colors[i]);
                }
            }
            catch (Exception e) {
                Log.e((String)"MaterialSpinner", (String)"Error setting background color", (Throwable)e);
            }
        } else if (background != null) {
            background.setColorFilter(color, PorterDuff.Mode.SRC_IN);
        }
        this.popupWindow.getBackground().setColorFilter(color, PorterDuff.Mode.SRC_IN);
    }

    public void setTextColor(int color) {
        this.textColor = color;
        if (this.adapter != null) {
            this.adapter.setTextColor(this.textColor);
            this.adapter.notifyDataSetChanged();
        }
        super.setTextColor(color);
    }

    public void setHintColor(int color) {
        this.hintColor = color;
        super.setTextColor(color);
    }

    public Parcelable onSaveInstanceState() {
        Bundle bundle = new Bundle();
        bundle.putParcelable("state", super.onSaveInstanceState());
        bundle.putInt("selected_index", this.selectedIndex);
        bundle.putBoolean("nothing_selected", this.nothingSelected);
        if (this.popupWindow != null) {
            bundle.putBoolean("is_popup_showing", this.popupWindow.isShowing());
            this.collapse();
        } else {
            bundle.putBoolean("is_popup_showing", false);
        }
        return bundle;
    }

    public void onRestoreInstanceState(Parcelable savedState) {
        if (savedState instanceof Bundle) {
            Bundle bundle = (Bundle)savedState;
            this.selectedIndex = bundle.getInt("selected_index");
            this.nothingSelected = bundle.getBoolean("nothing_selected");
            if (this.adapter != null) {
                if (this.nothingSelected && !TextUtils.isEmpty((CharSequence)this.hintText)) {
                    this.setHintColor(this.hintColor);
                    this.setText(this.hintText);
                } else {
                    this.setTextColor(this.textColor);
                    this.setText(this.adapter.get(this.selectedIndex).toString());
                }
                this.adapter.notifyItemSelected(this.selectedIndex);
            }
            if (bundle.getBoolean("is_popup_showing") && this.popupWindow != null) {
                this.post(new Runnable(){

                    @Override
                    public void run() {
                        MaterialSpinner.this.expand();
                    }
                });
            }
            savedState = bundle.getParcelable("state");
        }
        super.onRestoreInstanceState(savedState);
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (this.arrowDrawable != null) {
            this.arrowDrawable.setColorFilter(enabled ? this.arrowColor : this.arrowColorDisabled, PorterDuff.Mode.SRC_IN);
        }
    }

    public int getSelectedIndex() {
        return this.selectedIndex;
    }

    public void setSelectedIndex(int position) {
        if (this.adapter != null) {
            if (position >= 0 && position <= this.adapter.getCount()) {
                this.adapter.notifyItemSelected(position);
                this.selectedIndex = position;
                this.setText(this.adapter.get(position).toString());
            } else {
                throw new IllegalArgumentException("Position must be lower than adapter count!");
            }
        }
    }

    public void setOnItemSelectedListener(@Nullable OnItemSelectedListener onItemSelectedListener) {
        this.onItemSelectedListener = onItemSelectedListener;
    }

    public void setOnNothingSelectedListener(@Nullable OnNothingSelectedListener onNothingSelectedListener) {
        this.onNothingSelectedListener = onNothingSelectedListener;
    }

    public <T> void setItems(T ... items) {
        this.setItems(Arrays.asList(items));
    }

    public <T> void setItems(@NonNull List<T> items) {
        this.adapter = new MaterialSpinnerAdapter<T>(this.getContext(), items).setPopupPadding(this.popupPaddingLeft, this.popupPaddingTop, this.popupPaddingRight, this.popupPaddingBottom).setBackgroundSelector(this.backgroundSelector).setTextColor(this.textColor);
        this.setAdapterInternal(this.adapter);
    }

    public void setAdapter(@NonNull ListAdapter adapter) {
        this.adapter = new MaterialSpinnerAdapterWrapper(this.getContext(), adapter).setPopupPadding(this.popupPaddingLeft, this.popupPaddingTop, this.popupPaddingRight, this.popupPaddingBottom).setBackgroundSelector(this.backgroundSelector).setTextColor(this.textColor);
        this.setAdapterInternal(this.adapter);
    }

    public <T> void setAdapter(MaterialSpinnerAdapter<T> adapter) {
        this.adapter = adapter;
        this.adapter.setTextColor(this.textColor);
        this.adapter.setBackgroundSelector(this.backgroundSelector);
        this.adapter.setPopupPadding(this.popupPaddingLeft, this.popupPaddingTop, this.popupPaddingRight, this.popupPaddingBottom);
        this.setAdapterInternal(adapter);
    }

    private void setAdapterInternal(@NonNull MaterialSpinnerBaseAdapter adapter) {
        boolean shouldResetPopupHeight = this.listView.getAdapter() != null;
        adapter.setHintEnabled(!TextUtils.isEmpty((CharSequence)this.hintText));
        this.listView.setAdapter((ListAdapter)adapter);
        if (this.selectedIndex >= adapter.getCount()) {
            this.selectedIndex = 0;
        }
        if (adapter.getItems().size() > 0) {
            if (this.nothingSelected && !TextUtils.isEmpty((CharSequence)this.hintText)) {
                this.setText(this.hintText);
                this.setHintColor(this.hintColor);
            } else {
                this.setTextColor(this.textColor);
                this.setText(adapter.get(this.selectedIndex).toString());
            }
        } else {
            this.setText("");
        }
        if (shouldResetPopupHeight) {
            this.popupWindow.setHeight(this.calculatePopupWindowHeight());
        }
    }

    public <T> List<T> getItems() {
        if (this.adapter == null) {
            return null;
        }
        return this.adapter.getItems();
    }

    public void expand() {
        if (this.canShowPopup()) {
            if (!this.hideArrow) {
                this.animateArrow(true);
            }
            this.nothingSelected = true;
            this.popupWindow.showAsDropDown((View)this);
        }
    }

    public void collapse() {
        if (!this.hideArrow) {
            this.animateArrow(false);
        }
        this.popupWindow.dismiss();
    }

    public void setArrowColor(@ColorInt int color) {
        this.arrowColor = color;
        this.arrowColorDisabled = Utils.lighter(this.arrowColor, 0.8f);
        if (this.arrowDrawable != null) {
            this.arrowDrawable.setColorFilter(this.arrowColor, PorterDuff.Mode.SRC_IN);
        }
    }

    private boolean canShowPopup() {
        Activity activity = this.getActivity();
        if (activity == null || activity.isFinishing()) {
            return false;
        }
        boolean isLaidOut = Build.VERSION.SDK_INT >= 19 ? this.isLaidOut() : this.getWidth() > 0 && this.getHeight() > 0;
        return isLaidOut;
    }

    private Activity getActivity() {
        Context context = this.getContext();
        while (context instanceof ContextWrapper) {
            if (context instanceof Activity) {
                return (Activity)context;
            }
            context = ((ContextWrapper)context).getBaseContext();
        }
        return null;
    }

    private void animateArrow(boolean shouldRotateUp) {
        int start = shouldRotateUp ? 0 : 10000;
        int end = shouldRotateUp ? 10000 : 0;
        ObjectAnimator animator = ObjectAnimator.ofInt((Object)this.arrowDrawable, (String)"level", (int[])new int[]{start, end});
        animator.start();
    }

    public void setDropdownMaxHeight(int height) {
        this.popupWindowMaxHeight = height;
        this.popupWindow.setHeight(this.calculatePopupWindowHeight());
    }

    public void setDropdownHeight(int height) {
        this.popupWindowHeight = height;
        this.popupWindow.setHeight(this.calculatePopupWindowHeight());
    }

    private int calculatePopupWindowHeight() {
        if (this.adapter == null) {
            return -2;
        }
        float itemHeight = this.getResources().getDimension(R.dimen.ms__item_height);
        float listViewHeight = (float)this.adapter.getCount() * itemHeight;
        if (this.popupWindowMaxHeight > 0 && listViewHeight > (float)this.popupWindowMaxHeight) {
            return this.popupWindowMaxHeight;
        }
        if (this.popupWindowHeight != -1 && this.popupWindowHeight != -2 && (float)this.popupWindowHeight <= listViewHeight) {
            return this.popupWindowHeight;
        }
        if (listViewHeight == 0.0f && this.adapter.getItems().size() == 1) {
            return (int)itemHeight;
        }
        return -2;
    }

    public PopupWindow getPopupWindow() {
        return this.popupWindow;
    }

    public ListView getListView() {
        return this.listView;
    }

    public static interface OnNothingSelectedListener {
        public void onNothingSelected(MaterialSpinner var1);
    }

    public static interface OnItemSelectedListener<T> {
        public void onItemSelected(MaterialSpinner var1, int var2, long var3, T var5);
    }
}

