/*
 * Decompiled with CFR 0.152.
 */
package com.jaredrummler.materialspinner;

import android.content.Context;
import android.content.res.Configuration;
import android.os.Build;
import android.support.annotation.ColorInt;
import android.support.annotation.DrawableRes;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.TextView;
import com.jaredrummler.materialspinner.R;
import java.util.List;

public abstract class MaterialSpinnerBaseAdapter<T>
extends BaseAdapter {
    private final Context context;
    private int selectedIndex;
    private int textColor;
    private int backgroundSelector;

    public MaterialSpinnerBaseAdapter(Context context) {
        this.context = context;
    }

    public View getView(int position, View convertView, ViewGroup parent) {
        TextView textView;
        if (convertView == null) {
            Configuration config;
            LayoutInflater inflater = LayoutInflater.from((Context)this.context);
            convertView = inflater.inflate(R.layout.ms__list_item, parent, false);
            textView = (TextView)convertView.findViewById(R.id.tv_tinted_spinner);
            textView.setTextColor(this.textColor);
            if (this.backgroundSelector != 0) {
                textView.setBackgroundResource(this.backgroundSelector);
            }
            if (Build.VERSION.SDK_INT >= 17 && (config = this.context.getResources().getConfiguration()).getLayoutDirection() == 1) {
                textView.setTextDirection(4);
            }
            convertView.setTag((Object)new ViewHolder(textView));
        } else {
            textView = ((ViewHolder)convertView.getTag()).textView;
        }
        textView.setText((CharSequence)this.getItemText(position));
        return convertView;
    }

    public String getItemText(int position) {
        return this.getItem(position).toString();
    }

    public int getSelectedIndex() {
        return this.selectedIndex;
    }

    public void notifyItemSelected(int index) {
        this.selectedIndex = index;
    }

    public long getItemId(int position) {
        return position;
    }

    public abstract T getItem(int var1);

    public abstract int getCount();

    public abstract T get(int var1);

    public abstract List<T> getItems();

    public MaterialSpinnerBaseAdapter<T> setTextColor(@ColorInt int textColor) {
        this.textColor = textColor;
        return this;
    }

    public MaterialSpinnerBaseAdapter<T> setBackgroundSelector(@DrawableRes int backgroundSelector) {
        this.backgroundSelector = backgroundSelector;
        return this;
    }

    private static class ViewHolder {
        private TextView textView;

        private ViewHolder(TextView textView) {
            this.textView = textView;
        }
    }
}

