/*
 * Decompiled with CFR 0.152.
 */
package com.jantursky.debugger.listeners;

import android.annotation.SuppressLint;
import android.os.Handler;
import android.view.MotionEvent;
import android.view.View;

public class RepeatListener
implements View.OnTouchListener {
    private static final String TAG = RepeatListener.class.getSimpleName();
    private final View.OnClickListener clickListener;
    private Handler handler = new Handler();
    private long initialRepeatDelay;
    private long repeatIntervalInMilliseconds;
    private long repeatIntervalCurrent = this.repeatIntervalInMilliseconds;
    private long repeatIntervalStep = 10L;
    private long repeatIntervalMin = 10L;
    private boolean incrementSpeed;
    private View downView;
    private Runnable handlerRunnable = new Runnable(){

        @Override
        public void run() {
            RepeatListener.this.clickListener.onClick(RepeatListener.this.downView);
            if (RepeatListener.this.incrementSpeed && RepeatListener.this.repeatIntervalCurrent > RepeatListener.this.repeatIntervalMin) {
                RepeatListener.this.repeatIntervalCurrent = RepeatListener.this.repeatIntervalCurrent - RepeatListener.this.repeatIntervalStep;
            }
            RepeatListener.this.handler.postDelayed(RepeatListener.this.handlerRunnable, RepeatListener.this.repeatIntervalCurrent);
        }
    };

    public RepeatListener(long initialRepeatDelay, long repeatIntervalInMilliseconds, boolean incrementSpeed, View.OnClickListener clickListener) {
        if (clickListener == null) {
            throw new IllegalArgumentException("null runnable");
        }
        if (initialRepeatDelay < 0L || repeatIntervalInMilliseconds < 0L) {
            throw new IllegalArgumentException("negative interval");
        }
        this.initialRepeatDelay = initialRepeatDelay;
        this.repeatIntervalInMilliseconds = repeatIntervalInMilliseconds;
        this.clickListener = clickListener;
        this.incrementSpeed = incrementSpeed;
    }

    @SuppressLint(value={"ClickableViewAccessibility"})
    public boolean onTouch(View view, MotionEvent motionEvent) {
        int action = motionEvent.getAction();
        if (action == 0) {
            this.handler.removeCallbacks(this.handlerRunnable);
            this.repeatIntervalCurrent = this.repeatIntervalInMilliseconds;
            this.handler.postDelayed(this.handlerRunnable, this.initialRepeatDelay);
            this.downView = view;
            this.downView.setPressed(true);
            this.clickListener.onClick(view);
            return true;
        }
        if (action == 1 || action == 3) {
            this.handler.removeCallbacks(this.handlerRunnable);
            this.downView.setPressed(false);
            this.downView = null;
            return true;
        }
        return false;
    }
}

