/*
 * Decompiled with CFR 0.152.
 */
package com.jantursky.debugger.components.restclient.tasks;

import android.os.AsyncTask;
import android.util.Log;
import com.jantursky.debugger.components.restclient.interfaces.RestClientResultListener;
import com.jantursky.debugger.components.restclient.models.ApiCallModel;
import com.jantursky.debugger.components.restclient.models.ApiGeneralModel;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Map;
import javax.net.ssl.HttpsURLConnection;

public class ApiCallTask
extends AsyncTask<Void, Void, ApiCallModel> {
    private static final String TAG = ApiCallTask.class.getSimpleName();
    private final ApiCallModel model;
    private final ApiGeneralModel apiCallGeneralModel;
    private RestClientResultListener listener;

    public ApiCallTask(ApiGeneralModel apiCallGeneralModel, ApiCallModel apiCallModel, RestClientResultListener listener) {
        this.apiCallGeneralModel = apiCallGeneralModel;
        this.model = apiCallModel;
        this.listener = listener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ApiCallModel doInBackground(Void ... params) {
        HttpURLConnection connection = null;
        try {
            this.model.startTime = System.currentTimeMillis();
            Log.w((String)TAG, (String)("##### RUN API CALL " + this.model.type + " " + this.model.url));
            URL url = new URL(this.model.url);
            connection = (HttpsURLConnection)url.openConnection();
            connection.setReadTimeout(this.model.readTimeout);
            connection.setConnectTimeout(this.model.connectionTimeout);
            if (this.apiCallGeneralModel != null && this.apiCallGeneralModel.hasHeaders()) {
                for (Map.Entry<String, String> entry : this.apiCallGeneralModel.headers.entrySet()) {
                    connection.setRequestProperty(entry.getKey(), entry.getValue());
                }
            }
            if (this.model.headers != null) {
                for (Map.Entry<String, String> entry : this.model.headers.entrySet()) {
                    connection.setRequestProperty(entry.getKey(), entry.getValue());
                }
            }
            boolean canReadOutput = false;
            if (this.model.isPostType()) {
                canReadOutput = true;
                connection.setDoInput(true);
                connection.setDoOutput(true);
                connection.setRequestMethod("POST");
            } else if (this.model.isGetType()) {
                canReadOutput = true;
                connection.setRequestMethod("GET");
            } else if (this.model.isPutType()) {
                canReadOutput = true;
                connection.setDoInput(true);
                connection.setDoOutput(true);
                connection.setRequestMethod("PUT");
            } else if (this.model.isDeleteType()) {
                canReadOutput = true;
                connection.setDoInput(true);
                connection.setDoOutput(true);
                connection.setRequestMethod("DELETE");
            }
            if (this.model.hasInput()) {
                OutputStream os = connection.getOutputStream();
                os.write(this.model.body.getBytes("UTF-8"));
                os.flush();
                os.close();
            }
            connection.connect();
            int statusCode = connection.getResponseCode();
            if (statusCode >= 200 && statusCode < 300) {
                if (canReadOutput) {
                    try {
                        String line;
                        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(connection.getInputStream()));
                        StringBuilder total = new StringBuilder();
                        while ((line = bufferedReader.readLine()) != null) {
                            total.append(line).append('\n');
                        }
                        this.model.responseData = total.toString();
                        this.model.responseLength = total.length();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            } else if (canReadOutput) {
                try {
                    String line;
                    BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(connection.getErrorStream()));
                    StringBuilder total = new StringBuilder();
                    while ((line = bufferedReader.readLine()) != null) {
                        total.append(line).append('\n');
                    }
                    this.model.responseError = total.toString();
                    this.model.responseLength = total.length();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            this.model.responseCode = statusCode;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
        this.model.endTime = System.currentTimeMillis();
        return this.model;
    }

    protected void onCancelled(ApiCallModel apiCallModel) {
        if (this.listener != null) {
            this.model.isRunning = false;
            this.listener.onApiCallResult(this.model);
        }
    }

    protected void onPostExecute(ApiCallModel model) {
        if (this.listener != null) {
            model.isRunning = false;
            this.listener.onApiCallResult(model);
        }
    }
}

