/*
 * Decompiled with CFR 0.152.
 */
package com.jantursky.debugger.components.dbviewer.comparators;

import com.jantursky.debugger.components.dbviewer.models.DbViewerDataModel;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Locale;

public class DbGridComparator
implements Comparator<ArrayList<DbViewerDataModel>> {
    private int sortType = -1;
    private final Collator collator = Collator.getInstance(Locale.getDefault());
    private int row;

    public DbGridComparator() {
        this.collator.setStrength(1);
    }

    public void setRow(int row) {
        this.row = row;
    }

    @Override
    public int compare(ArrayList<DbViewerDataModel> db1, ArrayList<DbViewerDataModel> db2) {
        if (this.sortType == -1) {
            DbViewerDataModel model1 = db1.get(0);
            DbViewerDataModel model2 = db2.get(0);
            return this.compareTexts(model1.getText(), model2.getText());
        }
        DbViewerDataModel model1 = db1.get(this.row);
        DbViewerDataModel model2 = db2.get(this.row);
        if (this.sortType == 0) {
            return this.compareTexts(model1.getText(), model2.getText());
        }
        return -this.compareTexts(model1.getText(), model2.getText());
    }

    private boolean isDigit(char ch) {
        return ch >= '0' && ch <= '9';
    }

    private String getChunk(String s, int slength, int marker) {
        StringBuilder chunk = new StringBuilder();
        char c = s.charAt(marker);
        chunk.append(c);
        ++marker;
        if (this.isDigit(c)) {
            while (marker < slength && this.isDigit(c = s.charAt(marker))) {
                chunk.append(c);
                ++marker;
            }
        } else {
            while (marker < slength && !this.isDigit(c = s.charAt(marker))) {
                chunk.append(c);
                ++marker;
            }
        }
        return chunk.toString();
    }

    public int compareTexts(String s1, String s2) {
        if (s1 == null || s2 == null) {
            return 0;
        }
        int thisMarker = 0;
        int thatMarker = 0;
        int s1Length = s1.length();
        int s2Length = s2.length();
        while (thisMarker < s1Length && thatMarker < s2Length) {
            int result;
            String thisChunk = this.getChunk(s1, s1Length, thisMarker);
            thisMarker += thisChunk.length();
            String thatChunk = this.getChunk(s2, s2Length, thatMarker);
            thatMarker += thatChunk.length();
            if (this.isDigit(thisChunk.charAt(0)) && this.isDigit(thatChunk.charAt(0))) {
                int thisChunkLength = thisChunk.length();
                result = thisChunkLength - thatChunk.length();
                if (result == 0) {
                    for (int i = 0; i < thisChunkLength; ++i) {
                        result = thisChunk.charAt(i) - thatChunk.charAt(i);
                        if (result == 0) continue;
                        return result;
                    }
                }
            } else {
                result = thisChunk.compareTo(thatChunk);
            }
            if (result == 0) continue;
            return result;
        }
        return s1Length - s2Length;
    }

    public void setSortType(int sortType) {
        this.sortType = sortType;
    }

    public int getSortType() {
        return this.sortType;
    }
}

