/*
 * Decompiled with CFR 0.152.
 */
package com.jamonapi.distributed;

import com.jamonapi.JamonPropertiesLoader;
import com.jamonapi.distributed.JamonDataPersister;
import com.jamonapi.distributed.LocalJamonFilePersister;
import java.util.Properties;

public class JamonDataPersisterFactory {
    private static JamonDataPersisterFactory factory = new JamonDataPersisterFactory();
    private JamonDataPersister jamonDataPersister;
    private String jamonDataPersisterName;
    private Properties jamonProperties = new JamonPropertiesLoader().getJamonProperties();

    private JamonDataPersisterFactory() {
        this.jamonDataPersisterName = this.jamonProperties.getProperty("jamonDataPersister");
    }

    public static JamonDataPersister get() {
        if (JamonDataPersisterFactory.factory.jamonDataPersister == null) {
            factory.initialize();
        }
        return JamonDataPersisterFactory.factory.jamonDataPersister;
    }

    public static Properties getJamonProperties() {
        return JamonDataPersisterFactory.factory.jamonProperties;
    }

    private void initialize() {
        this.jamonDataPersister = JamonDataPersisterFactory.create(this.jamonDataPersisterName);
        if (this.jamonDataPersister == null) {
            this.jamonDataPersister = new LocalJamonFilePersister();
        }
    }

    private static JamonDataPersister create(String className) {
        try {
            return (JamonDataPersister)Class.forName(className).newInstance();
        }
        catch (Throwable throwable) {
            return null;
        }
    }
}

