/*
 * Decompiled with CFR 0.152.
 */
package com.jakewharton.rxbinding4.leanback;

import androidx.leanback.widget.SearchBar;
import com.jakewharton.rxbinding4.internal.Preconditions;
import com.jakewharton.rxbinding4.leanback.SearchBarSearchQueryChangedEvent;
import com.jakewharton.rxbinding4.leanback.SearchBarSearchQueryEvent;
import com.jakewharton.rxbinding4.leanback.SearchBarSearchQueryKeyboardDismissedEvent;
import com.jakewharton.rxbinding4.leanback.SearchBarSearchQuerySubmittedEvent;
import io.reactivex.rxjava3.android.MainThreadDisposable;
import io.reactivex.rxjava3.core.Observable;
import io.reactivex.rxjava3.core.Observer;
import io.reactivex.rxjava3.disposables.Disposable;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\nB\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0018\u0010\u0006\u001a\u00020\u00072\u000e\u0010\b\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u00020\tH\u0014R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/jakewharton/rxbinding4/leanback/SearchBarSearchQueryChangeEventsObservable;", "Lio/reactivex/rxjava3/core/Observable;", "Lcom/jakewharton/rxbinding4/leanback/SearchBarSearchQueryEvent;", "view", "Landroidx/leanback/widget/SearchBar;", "(Landroidx/leanback/widget/SearchBar;)V", "subscribeActual", "", "observer", "Lio/reactivex/rxjava3/core/Observer;", "Listener", "rxbinding-leanback_release"})
final class SearchBarSearchQueryChangeEventsObservable
extends Observable<SearchBarSearchQueryEvent> {
    private final SearchBar view;

    protected void subscribeActual(@NotNull Observer<? super SearchBarSearchQueryEvent> observer) {
        Intrinsics.checkParameterIsNotNull(observer, (String)"observer");
        if (!Preconditions.checkMainThread(observer)) {
            return;
        }
        Listener listener = new Listener(this.view, observer);
        observer.onSubscribe((Disposable)listener);
        this.view.setSearchBarListener((SearchBar.SearchBarListener)listener);
    }

    public SearchBarSearchQueryChangeEventsObservable(@NotNull SearchBar view) {
        Intrinsics.checkParameterIsNotNull((Object)view, (String)"view");
        this.view = view;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u000e\u0010\u0005\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u00070\u0006\u00a2\u0006\u0002\u0010\bJ\b\u0010\t\u001a\u00020\nH\u0014J\u0010\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000f\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\rH\u0016R\u0016\u0010\u0005\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/jakewharton/rxbinding4/leanback/SearchBarSearchQueryChangeEventsObservable$Listener;", "Lio/reactivex/rxjava3/android/MainThreadDisposable;", "Landroidx/leanback/widget/SearchBar$SearchBarListener;", "view", "Landroidx/leanback/widget/SearchBar;", "observer", "Lio/reactivex/rxjava3/core/Observer;", "Lcom/jakewharton/rxbinding4/leanback/SearchBarSearchQueryEvent;", "(Landroidx/leanback/widget/SearchBar;Lio/reactivex/rxjava3/core/Observer;)V", "onDispose", "", "onKeyboardDismiss", "query", "", "onSearchQueryChange", "onSearchQuerySubmit", "rxbinding-leanback_release"})
    private static final class Listener
    extends MainThreadDisposable
    implements SearchBar.SearchBarListener {
        private final SearchBar view;
        private final Observer<? super SearchBarSearchQueryEvent> observer;

        public void onSearchQueryChange(@NotNull String query) {
            Intrinsics.checkParameterIsNotNull((Object)query, (String)"query");
            if (!this.isDisposed()) {
                this.observer.onNext((Object)new SearchBarSearchQueryChangedEvent(this.view, query));
            }
        }

        public void onSearchQuerySubmit(@NotNull String query) {
            Intrinsics.checkParameterIsNotNull((Object)query, (String)"query");
            if (!this.isDisposed()) {
                this.observer.onNext((Object)new SearchBarSearchQuerySubmittedEvent(this.view, query));
            }
        }

        public void onKeyboardDismiss(@NotNull String query) {
            Intrinsics.checkParameterIsNotNull((Object)query, (String)"query");
            if (!this.isDisposed()) {
                this.observer.onNext((Object)new SearchBarSearchQueryKeyboardDismissedEvent(this.view, query));
            }
        }

        protected void onDispose() {
            this.view.setSearchBarListener(null);
        }

        public Listener(@NotNull SearchBar view, @NotNull Observer<? super SearchBarSearchQueryEvent> observer) {
            Intrinsics.checkParameterIsNotNull((Object)view, (String)"view");
            Intrinsics.checkParameterIsNotNull(observer, (String)"observer");
            this.view = view;
            this.observer = observer;
        }
    }
}

