/*
 * Decompiled with CFR 0.152.
 */
package com.jakewharton.rxbinding3.material;

import com.google.android.material.tabs.TabLayout;
import com.jakewharton.rxbinding3.internal.Preconditions;
import io.reactivex.Observable;
import io.reactivex.Observer;
import io.reactivex.android.MainThreadDisposable;
import io.reactivex.disposables.Disposable;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\nB\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0018\u0010\u0006\u001a\u00020\u00072\u000e\u0010\b\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u00020\tH\u0014R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/jakewharton/rxbinding3/material/TabLayoutSelectionsObservable;", "Lio/reactivex/Observable;", "Lcom/google/android/material/tabs/TabLayout$Tab;", "view", "Lcom/google/android/material/tabs/TabLayout;", "(Lcom/google/android/material/tabs/TabLayout;)V", "subscribeActual", "", "observer", "Lio/reactivex/Observer;", "Listener", "rxbinding-material_release"})
final class TabLayoutSelectionsObservable
extends Observable<TabLayout.Tab> {
    private final TabLayout view;

    protected void subscribeActual(@NotNull Observer<? super TabLayout.Tab> observer) {
        Intrinsics.checkParameterIsNotNull(observer, (String)"observer");
        if (!Preconditions.checkMainThread(observer)) {
            return;
        }
        Listener listener = new Listener(this.view, observer);
        observer.onSubscribe((Disposable)listener);
        this.view.addOnTabSelectedListener((TabLayout.BaseOnTabSelectedListener)listener);
        int index = this.view.getSelectedTabPosition();
        if (index != -1) {
            TabLayout.Tab tab = this.view.getTabAt(index);
            if (tab == null) {
                Intrinsics.throwNpe();
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)tab, (String)"view.getTabAt(index)!!");
            observer.onNext((Object)tab);
        }
    }

    public TabLayoutSelectionsObservable(@NotNull TabLayout view) {
        Intrinsics.checkParameterIsNotNull((Object)view, (String)"view");
        this.view = view;
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u0002\u0018\u00002\u00020\u00012\b\u0012\u0004\u0012\u00020\u00030\u0002B\u001d\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u000e\u0010\u0006\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u00030\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\t\u001a\u00020\nH\u0014J\u0010\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\u0003H\u0016J\u0010\u0010\r\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\u0003H\u0016J\u0010\u0010\u000e\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\u0003H\u0016R\u0016\u0010\u0006\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u00030\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/jakewharton/rxbinding3/material/TabLayoutSelectionsObservable$Listener;", "Lio/reactivex/android/MainThreadDisposable;", "Lcom/google/android/material/tabs/TabLayout$BaseOnTabSelectedListener;", "Lcom/google/android/material/tabs/TabLayout$Tab;", "tabLayout", "Lcom/google/android/material/tabs/TabLayout;", "observer", "Lio/reactivex/Observer;", "(Lcom/google/android/material/tabs/TabLayout;Lio/reactivex/Observer;)V", "onDispose", "", "onTabReselected", "tab", "onTabSelected", "onTabUnselected", "rxbinding-material_release"})
    private static final class Listener
    extends MainThreadDisposable
    implements TabLayout.BaseOnTabSelectedListener<TabLayout.Tab> {
        private final TabLayout tabLayout;
        private final Observer<? super TabLayout.Tab> observer;

        protected void onDispose() {
            this.tabLayout.removeOnTabSelectedListener((TabLayout.BaseOnTabSelectedListener)this);
        }

        public void onTabSelected(@NotNull TabLayout.Tab tab) {
            Intrinsics.checkParameterIsNotNull((Object)tab, (String)"tab");
            if (!this.isDisposed()) {
                this.observer.onNext((Object)tab);
            }
        }

        public void onTabUnselected(@NotNull TabLayout.Tab tab) {
            Intrinsics.checkParameterIsNotNull((Object)tab, (String)"tab");
        }

        public void onTabReselected(@NotNull TabLayout.Tab tab) {
            Intrinsics.checkParameterIsNotNull((Object)tab, (String)"tab");
        }

        public Listener(@NotNull TabLayout tabLayout, @NotNull Observer<? super TabLayout.Tab> observer) {
            Intrinsics.checkParameterIsNotNull((Object)tabLayout, (String)"tabLayout");
            Intrinsics.checkParameterIsNotNull(observer, (String)"observer");
            this.tabLayout = tabLayout;
            this.observer = observer;
        }
    }
}

