/*
 * Decompiled with CFR 0.152.
 */
package com.jakewharton.rxbinding2.widget;

import android.support.annotation.RequiresApi;
import android.view.View;
import android.widget.Toolbar;
import com.jakewharton.rxbinding2.internal.Notification;
import com.jakewharton.rxbinding2.internal.Preconditions;
import io.reactivex.Observable;
import io.reactivex.Observer;
import io.reactivex.android.MainThreadDisposable;
import io.reactivex.disposables.Disposable;

@RequiresApi(value=21)
final class ToolbarNavigationClickObservable
extends Observable<Object> {
    private final Toolbar view;

    ToolbarNavigationClickObservable(Toolbar view) {
        this.view = view;
    }

    protected void subscribeActual(Observer<? super Object> observer) {
        if (!Preconditions.checkMainThread(observer)) {
            return;
        }
        Listener listener = new Listener(this.view, observer);
        observer.onSubscribe((Disposable)listener);
        this.view.setNavigationOnClickListener((View.OnClickListener)listener);
    }

    static final class Listener
    extends MainThreadDisposable
    implements View.OnClickListener {
        private final Toolbar view;
        private final Observer<? super Object> observer;

        Listener(Toolbar view, Observer<? super Object> observer) {
            this.view = view;
            this.observer = observer;
        }

        public void onClick(View v) {
            if (!this.isDisposed()) {
                this.observer.onNext((Object)Notification.INSTANCE);
            }
        }

        protected void onDispose() {
            this.view.setNavigationOnClickListener(null);
        }
    }
}

