/*
 * Decompiled with CFR 0.152.
 */
package com.jakewharton.rxbinding2.widget;

import android.view.View;
import android.widget.AdapterView;
import com.jakewharton.rxbinding2.internal.Preconditions;
import com.jakewharton.rxbinding2.widget.AdapterViewItemLongClickEvent;
import io.reactivex.Observable;
import io.reactivex.Observer;
import io.reactivex.android.MainThreadDisposable;
import io.reactivex.disposables.Disposable;
import io.reactivex.functions.Predicate;

final class AdapterViewItemLongClickEventObservable
extends Observable<AdapterViewItemLongClickEvent> {
    private final AdapterView<?> view;
    private final Predicate<? super AdapterViewItemLongClickEvent> handled;

    AdapterViewItemLongClickEventObservable(AdapterView<?> view, Predicate<? super AdapterViewItemLongClickEvent> handled) {
        this.view = view;
        this.handled = handled;
    }

    protected void subscribeActual(Observer<? super AdapterViewItemLongClickEvent> observer) {
        if (!Preconditions.checkMainThread(observer)) {
            return;
        }
        Listener listener = new Listener(this.view, observer, this.handled);
        observer.onSubscribe((Disposable)listener);
        this.view.setOnItemLongClickListener((AdapterView.OnItemLongClickListener)listener);
    }

    static final class Listener
    extends MainThreadDisposable
    implements AdapterView.OnItemLongClickListener {
        private final AdapterView<?> view;
        private final Observer<? super AdapterViewItemLongClickEvent> observer;
        private final Predicate<? super AdapterViewItemLongClickEvent> handled;

        Listener(AdapterView<?> view, Observer<? super AdapterViewItemLongClickEvent> observer, Predicate<? super AdapterViewItemLongClickEvent> handled) {
            this.view = view;
            this.observer = observer;
            this.handled = handled;
        }

        public boolean onItemLongClick(AdapterView<?> parent, View view, int position, long id) {
            if (!this.isDisposed()) {
                AdapterViewItemLongClickEvent event = AdapterViewItemLongClickEvent.create(parent, view, position, id);
                try {
                    if (this.handled.test((Object)event)) {
                        this.observer.onNext((Object)event);
                        return true;
                    }
                }
                catch (Exception e) {
                    this.observer.onError((Throwable)e);
                    this.dispose();
                }
            }
            return false;
        }

        protected void onDispose() {
            this.view.setOnItemLongClickListener(null);
        }
    }
}

