/*
 * Decompiled with CFR 0.152.
 */
package com.jakewharton.rxbinding2.view;

import android.view.View;
import android.view.ViewGroup;
import com.jakewharton.rxbinding2.internal.Preconditions;
import com.jakewharton.rxbinding2.view.ViewGroupHierarchyChangeEvent;
import com.jakewharton.rxbinding2.view.ViewGroupHierarchyChildViewAddEvent;
import com.jakewharton.rxbinding2.view.ViewGroupHierarchyChildViewRemoveEvent;
import io.reactivex.Observable;
import io.reactivex.Observer;
import io.reactivex.android.MainThreadDisposable;
import io.reactivex.disposables.Disposable;

final class ViewGroupHierarchyChangeEventObservable
extends Observable<ViewGroupHierarchyChangeEvent> {
    private final ViewGroup viewGroup;

    ViewGroupHierarchyChangeEventObservable(ViewGroup viewGroup) {
        this.viewGroup = viewGroup;
    }

    protected void subscribeActual(Observer<? super ViewGroupHierarchyChangeEvent> observer) {
        if (!Preconditions.checkMainThread(observer)) {
            return;
        }
        Listener listener = new Listener(this.viewGroup, observer);
        observer.onSubscribe((Disposable)listener);
        this.viewGroup.setOnHierarchyChangeListener((ViewGroup.OnHierarchyChangeListener)listener);
    }

    static final class Listener
    extends MainThreadDisposable
    implements ViewGroup.OnHierarchyChangeListener {
        private final ViewGroup viewGroup;
        private final Observer<? super ViewGroupHierarchyChangeEvent> observer;

        Listener(ViewGroup viewGroup, Observer<? super ViewGroupHierarchyChangeEvent> observer) {
            this.viewGroup = viewGroup;
            this.observer = observer;
        }

        public void onChildViewAdded(View parent, View child) {
            if (!this.isDisposed()) {
                this.observer.onNext((Object)ViewGroupHierarchyChildViewAddEvent.create(this.viewGroup, child));
            }
        }

        public void onChildViewRemoved(View parent, View child) {
            if (!this.isDisposed()) {
                this.observer.onNext((Object)ViewGroupHierarchyChildViewRemoveEvent.create(this.viewGroup, child));
            }
        }

        protected void onDispose() {
            this.viewGroup.setOnHierarchyChangeListener(null);
        }
    }
}

