/*
 * Decompiled with CFR 0.152.
 */
package com.jakewharton.rxbinding2.view;

import android.view.DragEvent;
import android.view.View;
import com.jakewharton.rxbinding2.internal.Preconditions;
import io.reactivex.Observable;
import io.reactivex.Observer;
import io.reactivex.android.MainThreadDisposable;
import io.reactivex.disposables.Disposable;
import io.reactivex.functions.Predicate;

final class ViewDragObservable
extends Observable<DragEvent> {
    private final View view;
    private final Predicate<? super DragEvent> handled;

    ViewDragObservable(View view, Predicate<? super DragEvent> handled) {
        this.view = view;
        this.handled = handled;
    }

    protected void subscribeActual(Observer<? super DragEvent> observer) {
        if (!Preconditions.checkMainThread(observer)) {
            return;
        }
        Listener listener = new Listener(this.view, this.handled, observer);
        observer.onSubscribe((Disposable)listener);
        this.view.setOnDragListener((View.OnDragListener)listener);
    }

    static final class Listener
    extends MainThreadDisposable
    implements View.OnDragListener {
        private final View view;
        private final Predicate<? super DragEvent> handled;
        private final Observer<? super DragEvent> observer;

        Listener(View view, Predicate<? super DragEvent> handled, Observer<? super DragEvent> observer) {
            this.view = view;
            this.handled = handled;
            this.observer = observer;
        }

        public boolean onDrag(View v, DragEvent event) {
            if (!this.isDisposed()) {
                try {
                    if (this.handled.test((Object)event)) {
                        this.observer.onNext((Object)event);
                        return true;
                    }
                }
                catch (Exception e) {
                    this.observer.onError((Throwable)e);
                    this.dispose();
                }
            }
            return false;
        }

        protected void onDispose() {
            this.view.setOnDragListener(null);
        }
    }
}

