/*
 * Decompiled with CFR 0.152.
 */
package com.jakewharton.rxbinding2.view;

import android.view.MenuItem;
import com.jakewharton.rxbinding2.internal.Notification;
import com.jakewharton.rxbinding2.internal.Preconditions;
import io.reactivex.Observable;
import io.reactivex.Observer;
import io.reactivex.android.MainThreadDisposable;
import io.reactivex.disposables.Disposable;
import io.reactivex.functions.Predicate;

final class MenuItemClickOnSubscribe
extends Observable<Object> {
    private final MenuItem menuItem;
    private final Predicate<? super MenuItem> handled;

    MenuItemClickOnSubscribe(MenuItem menuItem, Predicate<? super MenuItem> handled) {
        this.menuItem = menuItem;
        this.handled = handled;
    }

    protected void subscribeActual(Observer<? super Object> observer) {
        if (!Preconditions.checkMainThread(observer)) {
            return;
        }
        Listener listener = new Listener(this.menuItem, this.handled, observer);
        observer.onSubscribe((Disposable)listener);
        this.menuItem.setOnMenuItemClickListener((MenuItem.OnMenuItemClickListener)listener);
    }

    static final class Listener
    extends MainThreadDisposable
    implements MenuItem.OnMenuItemClickListener {
        private final MenuItem menuItem;
        private final Predicate<? super MenuItem> handled;
        private final Observer<? super Object> observer;

        Listener(MenuItem menuItem, Predicate<? super MenuItem> handled, Observer<? super Object> observer) {
            this.menuItem = menuItem;
            this.handled = handled;
            this.observer = observer;
        }

        public boolean onMenuItemClick(MenuItem item) {
            if (!this.isDisposed()) {
                try {
                    if (this.handled.test((Object)this.menuItem)) {
                        this.observer.onNext((Object)Notification.INSTANCE);
                        return true;
                    }
                }
                catch (Exception e) {
                    this.observer.onError((Throwable)e);
                    this.dispose();
                }
            }
            return false;
        }

        protected void onDispose() {
            this.menuItem.setOnMenuItemClickListener(null);
        }
    }
}

