/*
 * Decompiled with CFR 0.152.
 */
package com.jakewharton.rxbinding2.widget;

import android.view.MenuItem;
import android.widget.PopupMenu;
import com.jakewharton.rxbinding2.internal.Preconditions;
import io.reactivex.Observable;
import io.reactivex.Observer;
import io.reactivex.android.MainThreadDisposable;
import io.reactivex.disposables.Disposable;

final class PopupMenuItemClickObservable
extends Observable<MenuItem> {
    private final PopupMenu view;

    PopupMenuItemClickObservable(PopupMenu view) {
        this.view = view;
    }

    protected void subscribeActual(Observer<? super MenuItem> observer) {
        if (!Preconditions.checkMainThread(observer)) {
            return;
        }
        Listener listener = new Listener(this.view, observer);
        this.view.setOnMenuItemClickListener((PopupMenu.OnMenuItemClickListener)listener);
        observer.onSubscribe((Disposable)listener);
    }

    static final class Listener
    extends MainThreadDisposable
    implements PopupMenu.OnMenuItemClickListener {
        private final PopupMenu view;
        private final Observer<? super MenuItem> observer;

        Listener(PopupMenu view, Observer<? super MenuItem> observer) {
            this.view = view;
            this.observer = observer;
        }

        public boolean onMenuItemClick(MenuItem menuItem) {
            if (!this.isDisposed()) {
                this.observer.onNext((Object)menuItem);
                return true;
            }
            return false;
        }

        protected void onDispose() {
            this.view.setOnMenuItemClickListener(null);
        }
    }
}

