/*
 * Decompiled with CFR 0.152.
 */
package com.jakewharton.rxbinding2.support.v7.widget;

import android.support.v7.widget.RecyclerView;
import com.jakewharton.rxbinding2.internal.Preconditions;
import io.reactivex.Observable;
import io.reactivex.Observer;
import io.reactivex.android.MainThreadDisposable;
import io.reactivex.disposables.Disposable;

final class RecyclerViewScrollStateChangeObservable
extends Observable<Integer> {
    private final RecyclerView view;

    RecyclerViewScrollStateChangeObservable(RecyclerView view) {
        this.view = view;
    }

    protected void subscribeActual(Observer<? super Integer> observer) {
        if (!Preconditions.checkMainThread(observer)) {
            return;
        }
        Listener listener = new Listener(this.view, observer);
        observer.onSubscribe((Disposable)listener);
        this.view.addOnScrollListener(listener.scrollListener);
    }

    final class Listener
    extends MainThreadDisposable {
        private final RecyclerView recyclerView;
        final RecyclerView.OnScrollListener scrollListener;

        Listener(RecyclerView recyclerView, final Observer<? super Integer> observer) {
            this.recyclerView = recyclerView;
            this.scrollListener = new RecyclerView.OnScrollListener(){

                public void onScrollStateChanged(RecyclerView recyclerView, int newState) {
                    if (!Listener.this.isDisposed()) {
                        observer.onNext((Object)newState);
                    }
                }
            };
        }

        protected void onDispose() {
            this.recyclerView.removeOnScrollListener(this.scrollListener);
        }
    }
}

