/*
 * Decompiled with CFR 0.152.
 */
package com.jakewharton.rxbinding2.support.design.widget;

import android.support.design.widget.CoordinatorLayout;
import android.support.design.widget.SwipeDismissBehavior;
import android.view.View;
import com.jakewharton.rxbinding2.internal.Preconditions;
import io.reactivex.Observable;
import io.reactivex.Observer;
import io.reactivex.android.MainThreadDisposable;
import io.reactivex.disposables.Disposable;

final class SwipeDismissBehaviorObservable
extends Observable<View> {
    private final View view;

    SwipeDismissBehaviorObservable(View view) {
        this.view = view;
    }

    protected void subscribeActual(Observer<? super View> observer) {
        if (!Preconditions.checkMainThread(observer)) {
            return;
        }
        if (!(this.view.getLayoutParams() instanceof CoordinatorLayout.LayoutParams)) {
            throw new IllegalArgumentException("The view is not in a Coordinator Layout.");
        }
        CoordinatorLayout.LayoutParams params = (CoordinatorLayout.LayoutParams)this.view.getLayoutParams();
        SwipeDismissBehavior behavior = (SwipeDismissBehavior)params.getBehavior();
        if (behavior == null) {
            throw new IllegalStateException("There's no behavior set on this view.");
        }
        Listener listener = new Listener(behavior, observer);
        observer.onSubscribe((Disposable)listener);
        behavior.setListener((SwipeDismissBehavior.OnDismissListener)listener);
    }

    static final class Listener
    extends MainThreadDisposable
    implements SwipeDismissBehavior.OnDismissListener {
        private final SwipeDismissBehavior swipeDismissBehavior;
        private final Observer<? super View> observer;

        Listener(SwipeDismissBehavior swipeDismissBehavior, Observer<? super View> observer) {
            this.swipeDismissBehavior = swipeDismissBehavior;
            this.observer = observer;
        }

        public void onDismiss(View view) {
            if (!this.isDisposed()) {
                this.observer.onNext((Object)view);
            }
        }

        public void onDragStateChanged(int state) {
        }

        protected void onDispose() {
            this.swipeDismissBehavior.setListener(null);
        }
    }
}

