/*
 * Decompiled with CFR 0.152.
 */
package com.jakewharton.rxbinding2.support.design.widget;

import android.support.annotation.CheckResult;
import android.support.annotation.NonNull;
import android.support.design.widget.TabLayout;
import com.jakewharton.rxbinding2.internal.Preconditions;
import com.jakewharton.rxbinding2.support.design.widget.TabLayoutSelectionEvent;
import com.jakewharton.rxbinding2.support.design.widget.TabLayoutSelectionEventObservable;
import com.jakewharton.rxbinding2.support.design.widget.TabLayoutSelectionsObservable;
import io.reactivex.Observable;
import io.reactivex.functions.Consumer;

public final class RxTabLayout {
    @CheckResult
    @NonNull
    public static Observable<TabLayout.Tab> selections(@NonNull TabLayout view) {
        Preconditions.checkNotNull((Object)view, (String)"view == null");
        return new TabLayoutSelectionsObservable(view);
    }

    @CheckResult
    @NonNull
    public static Observable<TabLayoutSelectionEvent> selectionEvents(@NonNull TabLayout view) {
        Preconditions.checkNotNull((Object)view, (String)"view == null");
        return new TabLayoutSelectionEventObservable(view);
    }

    @CheckResult
    @NonNull
    public static Consumer<? super Integer> select(@NonNull TabLayout view) {
        Preconditions.checkNotNull((Object)view, (String)"view == null");
        return index -> {
            if (index < 0 || index >= view.getTabCount()) {
                throw new IllegalArgumentException("No tab for index " + index);
            }
            view.getTabAt(index.intValue()).select();
        };
    }

    private RxTabLayout() {
        throw new AssertionError((Object)"No instances.");
    }
}

