/*
 * Decompiled with CFR 0.152.
 */
package com.jakewharton.rxbinding2.support.design.widget;

import android.support.design.widget.TabLayout;
import com.jakewharton.rxbinding2.internal.Preconditions;
import io.reactivex.Observable;
import io.reactivex.Observer;
import io.reactivex.android.MainThreadDisposable;
import io.reactivex.disposables.Disposable;

final class TabLayoutSelectionsObservable
extends Observable<TabLayout.Tab> {
    private final TabLayout view;

    TabLayoutSelectionsObservable(TabLayout view) {
        this.view = view;
    }

    protected void subscribeActual(Observer<? super TabLayout.Tab> observer) {
        if (!Preconditions.checkMainThread(observer)) {
            return;
        }
        Listener listener = new Listener(this.view, observer);
        observer.onSubscribe((Disposable)listener);
        this.view.addOnTabSelectedListener((TabLayout.OnTabSelectedListener)listener);
        int index = this.view.getSelectedTabPosition();
        if (index != -1) {
            observer.onNext((Object)this.view.getTabAt(index));
        }
    }

    static final class Listener
    extends MainThreadDisposable
    implements TabLayout.OnTabSelectedListener {
        private final TabLayout tabLayout;
        private final Observer<? super TabLayout.Tab> observer;

        Listener(TabLayout tabLayout, Observer<? super TabLayout.Tab> observer) {
            this.tabLayout = tabLayout;
            this.observer = observer;
        }

        protected void onDispose() {
            this.tabLayout.removeOnTabSelectedListener((TabLayout.OnTabSelectedListener)this);
        }

        public void onTabSelected(TabLayout.Tab tab) {
            if (!this.isDisposed()) {
                this.observer.onNext((Object)tab);
            }
        }

        public void onTabUnselected(TabLayout.Tab tab) {
        }

        public void onTabReselected(TabLayout.Tab tab) {
        }
    }
}

