/*
 * Decompiled with CFR 0.152.
 */
package com.jakewharton.rxbinding2.support.design.widget;

import android.support.annotation.NonNull;
import android.support.design.widget.BottomNavigationView;
import android.view.Menu;
import android.view.MenuItem;
import com.jakewharton.rxbinding2.internal.Preconditions;
import io.reactivex.Observable;
import io.reactivex.Observer;
import io.reactivex.android.MainThreadDisposable;
import io.reactivex.disposables.Disposable;

final class BottomNavigationViewItemSelectionsObservable
extends Observable<MenuItem> {
    private final BottomNavigationView view;

    BottomNavigationViewItemSelectionsObservable(BottomNavigationView view) {
        this.view = view;
    }

    protected void subscribeActual(Observer<? super MenuItem> observer) {
        if (!Preconditions.checkMainThread(observer)) {
            return;
        }
        Listener listener = new Listener(this.view, observer);
        observer.onSubscribe((Disposable)listener);
        this.view.setOnNavigationItemSelectedListener((BottomNavigationView.OnNavigationItemSelectedListener)listener);
        Menu menu = this.view.getMenu();
        int count = menu.size();
        for (int i = 0; i < count; ++i) {
            MenuItem item = menu.getItem(i);
            if (!item.isChecked()) continue;
            observer.onNext((Object)item);
            break;
        }
    }

    static final class Listener
    extends MainThreadDisposable
    implements BottomNavigationView.OnNavigationItemSelectedListener {
        private final BottomNavigationView bottomNavigationView;
        private final Observer<? super MenuItem> observer;

        Listener(BottomNavigationView bottomNavigationView, Observer<? super MenuItem> observer) {
            this.bottomNavigationView = bottomNavigationView;
            this.observer = observer;
        }

        public boolean onNavigationItemSelected(@NonNull MenuItem item) {
            if (!this.isDisposed()) {
                this.observer.onNext((Object)item);
            }
            return true;
        }

        protected void onDispose() {
            this.bottomNavigationView.setOnNavigationItemSelectedListener(null);
        }
    }
}

