/*
 * Decompiled with CFR 0.152.
 */
package com.jakewharton.rxbinding2.support.v7.widget;

import android.support.v7.widget.PopupMenu;
import android.view.MenuItem;
import com.jakewharton.rxbinding2.internal.Preconditions;
import io.reactivex.Observable;
import io.reactivex.Observer;
import io.reactivex.android.MainThreadDisposable;
import io.reactivex.disposables.Disposable;

final class PopupMenuItemClickObservable
extends Observable<MenuItem> {
    private final PopupMenu view;

    PopupMenuItemClickObservable(PopupMenu view) {
        this.view = view;
    }

    protected void subscribeActual(Observer<? super MenuItem> observer) {
        if (!Preconditions.checkMainThread(observer)) {
            return;
        }
        Listener listener = new Listener(this.view, observer);
        observer.onSubscribe((Disposable)listener);
        this.view.setOnMenuItemClickListener((PopupMenu.OnMenuItemClickListener)listener);
    }

    static final class Listener
    extends MainThreadDisposable
    implements PopupMenu.OnMenuItemClickListener {
        private final PopupMenu popupMenu;
        private final Observer<? super MenuItem> observer;

        Listener(PopupMenu popupMenu, Observer<? super MenuItem> observer) {
            this.popupMenu = popupMenu;
            this.observer = observer;
        }

        public boolean onMenuItemClick(MenuItem item) {
            if (!this.isDisposed()) {
                this.observer.onNext((Object)item);
            }
            return true;
        }

        protected void onDispose() {
            this.popupMenu.setOnMenuItemClickListener(null);
        }
    }
}

