/*
 * Decompiled with CFR 0.152.
 */
package com.jakewharton.rxbinding2.support.v7.widget;

import android.support.v7.widget.ActionMenuView;
import android.view.MenuItem;
import com.jakewharton.rxbinding2.internal.Preconditions;
import io.reactivex.Observable;
import io.reactivex.Observer;
import io.reactivex.android.MainThreadDisposable;
import io.reactivex.disposables.Disposable;

final class ActionMenuViewItemClickObservable
extends Observable<MenuItem> {
    private final ActionMenuView view;

    ActionMenuViewItemClickObservable(ActionMenuView view) {
        this.view = view;
    }

    protected void subscribeActual(Observer<? super MenuItem> observer) {
        if (!Preconditions.checkMainThread(observer)) {
            return;
        }
        Listener listener = new Listener(this.view, observer);
        observer.onSubscribe((Disposable)listener);
        this.view.setOnMenuItemClickListener((ActionMenuView.OnMenuItemClickListener)listener);
    }

    static final class Listener
    extends MainThreadDisposable
    implements ActionMenuView.OnMenuItemClickListener {
        private final ActionMenuView actionMenuView;
        private final Observer<? super MenuItem> observer;

        Listener(ActionMenuView actionMenuView, Observer<? super MenuItem> observer) {
            this.actionMenuView = actionMenuView;
            this.observer = observer;
        }

        public boolean onMenuItemClick(MenuItem item) {
            if (!this.isDisposed()) {
                this.observer.onNext((Object)item);
            }
            return true;
        }

        protected void onDispose() {
            this.actionMenuView.setOnMenuItemClickListener(null);
        }
    }
}

