/*
 * Decompiled with CFR 0.152.
 */
package com.jakewharton.rxbinding2.support.v7.widget;

import android.support.v7.widget.SearchView;
import com.jakewharton.rxbinding2.InitialValueObservable;
import com.jakewharton.rxbinding2.internal.Preconditions;
import com.jakewharton.rxbinding2.support.v7.widget.SearchViewQueryTextEvent;
import io.reactivex.Observer;
import io.reactivex.android.MainThreadDisposable;
import io.reactivex.disposables.Disposable;

final class SearchViewQueryTextChangeEventsObservable
extends InitialValueObservable<SearchViewQueryTextEvent> {
    private final SearchView view;

    SearchViewQueryTextChangeEventsObservable(SearchView view) {
        this.view = view;
    }

    protected void subscribeListener(Observer<? super SearchViewQueryTextEvent> observer) {
        if (!Preconditions.checkMainThread(observer)) {
            return;
        }
        Listener listener = new Listener(this.view, observer);
        observer.onSubscribe((Disposable)listener);
        this.view.setOnQueryTextListener((SearchView.OnQueryTextListener)listener);
    }

    protected SearchViewQueryTextEvent getInitialValue() {
        return SearchViewQueryTextEvent.create(this.view, this.view.getQuery(), false);
    }

    final class Listener
    extends MainThreadDisposable
    implements SearchView.OnQueryTextListener {
        private final SearchView searchView;
        private final Observer<? super SearchViewQueryTextEvent> observer;

        Listener(SearchView searchView, Observer<? super SearchViewQueryTextEvent> observer) {
            this.searchView = searchView;
            this.observer = observer;
        }

        public boolean onQueryTextChange(String s) {
            if (!this.isDisposed()) {
                this.observer.onNext((Object)SearchViewQueryTextEvent.create(SearchViewQueryTextChangeEventsObservable.this.view, s, false));
                return true;
            }
            return false;
        }

        public boolean onQueryTextSubmit(String query) {
            if (!this.isDisposed()) {
                this.observer.onNext((Object)SearchViewQueryTextEvent.create(SearchViewQueryTextChangeEventsObservable.this.view, SearchViewQueryTextChangeEventsObservable.this.view.getQuery(), true));
                return true;
            }
            return false;
        }

        protected void onDispose() {
            this.searchView.setOnQueryTextListener(null);
        }
    }
}

