/*
 * Decompiled with CFR 0.152.
 */
package butterknife.internal;

import butterknife.internal.Binding;
import butterknife.internal.FieldBinding;
import butterknife.internal.Listener;
import butterknife.internal.MethodBinding;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

final class ViewInjection {
    private final int id;
    private final Set<FieldBinding> fieldBindings = new LinkedHashSet<FieldBinding>();
    private final Map<Listener, MethodBinding> methodBindings = new LinkedHashMap<Listener, MethodBinding>();

    ViewInjection(int id) {
        this.id = id;
    }

    public int getId() {
        return this.id;
    }

    public Collection<FieldBinding> getFieldBindings() {
        return this.fieldBindings;
    }

    public Map<Listener, MethodBinding> getMethodBindings() {
        return Collections.unmodifiableMap(new LinkedHashMap<Listener, MethodBinding>(this.methodBindings));
    }

    public List<Binding> getRequiredBindings() {
        ArrayList<Binding> requiredBindings = new ArrayList<Binding>();
        for (FieldBinding fieldBinding : this.fieldBindings) {
            if (!fieldBinding.isRequired()) continue;
            requiredBindings.add(fieldBinding);
        }
        for (MethodBinding methodBinding : this.methodBindings.values()) {
            if (!methodBinding.isRequired()) continue;
            requiredBindings.add(methodBinding);
        }
        return requiredBindings;
    }

    public void addMethodBinding(Listener listener, MethodBinding methodBinding) {
        MethodBinding existingBinding = this.methodBindings.get(listener);
        if (existingBinding != null) {
            throw new IllegalStateException("View " + this.id + " already has method binding for " + listener.getType() + " on " + existingBinding.getName());
        }
        this.methodBindings.put(listener, methodBinding);
    }

    public void addFieldBinding(FieldBinding fieldBinding) {
        this.fieldBindings.add(fieldBinding);
    }
}

