/*
 * Decompiled with CFR 0.152.
 */
package butterknife.internal;

import java.lang.reflect.Method;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.List;

final class Listener {
    private final String ownerType;
    private final String setterName;
    private final String type;
    private final String returnType;
    private final String methodName;
    private final List<String> parameterTypes;

    static Listener from(Class<?> listenerClass) {
        Method[] listenerDeclaredMethods = listenerClass.getDeclaredMethods();
        if (listenerDeclaredMethods.length != 1) {
            throw new IllegalArgumentException(listenerClass.getSimpleName() + " is not a single-method interface");
        }
        Method listenerMethod = listenerDeclaredMethods[0];
        String ownerType = listenerClass.getDeclaringClass().getCanonicalName();
        String setterName = "set" + listenerClass.getSimpleName();
        String type = listenerClass.getCanonicalName();
        String methodName = listenerMethod.getName();
        String returnType = listenerMethod.getReturnType().getCanonicalName();
        Class<?>[] listenerParameterTypes = listenerMethod.getParameterTypes();
        ArrayList<String> parameterTypes = new ArrayList<String>(listenerParameterTypes.length);
        for (Class<?> listenerParameterType : listenerParameterTypes) {
            String parameterType;
            StringBuilder builder = new StringBuilder(listenerParameterType.getCanonicalName());
            TypeVariable<Class<?>>[] typeParameters = listenerParameterType.getTypeParameters();
            if (typeParameters.length > 0) {
                builder.append('<');
                for (int i = 0; i < typeParameters.length; ++i) {
                    if (i > 0) {
                        builder.append(',');
                    }
                    builder.append('?');
                }
                builder.append('>');
            }
            if ((parameterType = builder.toString()).startsWith("java.lang.") && !parameterType.substring(10).contains(".")) {
                parameterType = parameterType.substring(10);
            }
            parameterTypes.add(parameterType);
        }
        return new Listener(ownerType, setterName, type, returnType, methodName, parameterTypes);
    }

    private Listener(String ownerType, String setterName, String type, String returnType, String methodName, List<String> parameterTypes) {
        this.ownerType = ownerType;
        this.setterName = setterName;
        this.type = type;
        this.returnType = returnType;
        this.methodName = methodName;
        this.parameterTypes = parameterTypes;
    }

    public String getOwnerType() {
        return this.ownerType;
    }

    public String getSetterName() {
        return this.setterName;
    }

    String getType() {
        return this.type;
    }

    String getReturnType() {
        return this.returnType;
    }

    String getMethodName() {
        return this.methodName;
    }

    List<String> getParameterTypes() {
        return this.parameterTypes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Listener listener = (Listener)o;
        return this.methodName.equals(listener.methodName) && this.ownerType.equals(listener.ownerType) && ((Object)this.parameterTypes).equals(listener.parameterTypes) && this.returnType.equals(listener.returnType) && this.setterName.equals(listener.setterName) && this.type.equals(listener.type);
    }

    public int hashCode() {
        int result = this.ownerType.hashCode();
        result = 31 * result + this.setterName.hashCode();
        result = 31 * result + this.type.hashCode();
        result = 31 * result + this.returnType.hashCode();
        result = 31 * result + this.methodName.hashCode();
        result = 31 * result + ((Object)this.parameterTypes).hashCode();
        return result;
    }
}

