/*
 * Decompiled with CFR 0.152.
 */
package butterknife.compiler;

import androidx.annotation.Nullable;
import butterknife.compiler.BindingSet;
import butterknife.compiler.Id;
import butterknife.compiler.ResourceBinding;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.Immutable;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import java.util.ArrayList;
import java.util.Collections;

final class FieldResourceBinding
implements ResourceBinding {
    private final Id id;
    private final String name;
    private final Type type;

    FieldResourceBinding(Id id, String name, Type type) {
        this.id = id;
        this.name = name;
        this.type = type;
    }

    @Override
    public Id id() {
        return this.id;
    }

    @Override
    public boolean requiresResources(int sdk) {
        return this.type.methodForSdk((int)sdk).requiresResources;
    }

    @Override
    public CodeBlock render(int sdk) {
        ResourceMethod method = this.type.methodForSdk(sdk);
        if (method.typeName == null) {
            if (method.requiresResources) {
                return CodeBlock.of((String)"target.$L = res.$L($L)", (Object[])new Object[]{this.name, method.name, this.id.code});
            }
            return CodeBlock.of((String)"target.$L = context.$L($L)", (Object[])new Object[]{this.name, method.name, this.id.code});
        }
        if (method.requiresResources) {
            return CodeBlock.of((String)"target.$L = $T.$L(res, $L)", (Object[])new Object[]{this.name, method.typeName, method.name, this.id.code});
        }
        return CodeBlock.of((String)"target.$L = $T.$L(context, $L)", (Object[])new Object[]{this.name, method.typeName, method.name, this.id.code});
    }

    @Immutable
    static final class ResourceMethod
    implements Comparable<ResourceMethod> {
        @Nullable
        final ClassName typeName;
        final String name;
        final boolean requiresResources;
        final int sdk;

        ResourceMethod(@Nullable ClassName typeName, String name, boolean requiresResources, int sdk) {
            this.typeName = typeName;
            this.name = name;
            this.requiresResources = requiresResources;
            this.sdk = sdk;
        }

        @Override
        public int compareTo(ResourceMethod other) {
            return Integer.compare(this.sdk, other.sdk);
        }
    }

    static enum Type {
        BITMAP(new ResourceMethod(BindingSet.BITMAP_FACTORY, "decodeResource", true, 1)),
        BOOL("getBoolean"),
        COLOR(new ResourceMethod(BindingSet.CONTEXT_COMPAT, "getColor", false, 1), new ResourceMethod(null, "getColor", false, 23)),
        COLOR_STATE_LIST(new ResourceMethod(BindingSet.CONTEXT_COMPAT, "getColorStateList", false, 1), new ResourceMethod(null, "getColorStateList", false, 23)),
        DIMEN_AS_INT("getDimensionPixelSize"),
        DIMEN_AS_FLOAT("getDimension"),
        FLOAT(new ResourceMethod(BindingSet.UTILS, "getFloat", false, 1)),
        INT("getInteger"),
        INT_ARRAY("getIntArray"),
        STRING("getString"),
        STRING_ARRAY("getStringArray"),
        TEXT_ARRAY("getTextArray"),
        TYPED_ARRAY("obtainTypedArray");

        private final ImmutableList<ResourceMethod> methods;

        private Type(ResourceMethod ... methods) {
            ArrayList methodList = new ArrayList(methods.length);
            Collections.addAll(methodList, methods);
            Collections.sort(methodList);
            Collections.reverse(methodList);
            this.methods = ImmutableList.copyOf(methodList);
        }

        private Type(String methodName) {
            this.methods = ImmutableList.of((Object)new ResourceMethod(null, methodName, true, 1));
        }

        ResourceMethod methodForSdk(int sdk) {
            for (ResourceMethod method : this.methods) {
                if (method.sdk > sdk) continue;
                return method;
            }
            throw new AssertionError();
        }
    }
}

