/*
 * Decompiled with CFR 0.152.
 */
package com.jakebarnby.simpleml.objects.view;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import com.google.mlkit.vision.objects.DetectedObject;
import com.jakebarnby.simpleml.camera2.view.GraphicOverlay;
import java.util.Arrays;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0012\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0016R\u0016\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\nR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\nR\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\n\u00a8\u0006\u0014"}, d2={"Lcom/jakebarnby/simpleml/objects/view/ObjectGraphic;", "Lcom/jakebarnby/simpleml/camera2/view/GraphicOverlay$Graphic;", "overlay", "Lcom/jakebarnby/simpleml/camera2/view/GraphicOverlay;", "detectedObject", "Lcom/google/mlkit/vision/objects/DetectedObject;", "(Lcom/jakebarnby/simpleml/camera2/view/GraphicOverlay;Lcom/google/mlkit/vision/objects/DetectedObject;)V", "boxPaints", "", "Landroid/graphics/Paint;", "[Landroid/graphics/Paint;", "labelPaints", "numColors", "", "textPaints", "draw", "", "canvas", "Landroid/graphics/Canvas;", "Companion", "simpleml-objects_release"})
public final class ObjectGraphic
extends GraphicOverlay.Graphic {
    private final int numColors;
    private final Paint[] boxPaints;
    private final Paint[] textPaints;
    private final Paint[] labelPaints;
    private final DetectedObject detectedObject;
    private static final float TEXT_SIZE = 54.0f;
    private static final float STROKE_WIDTH = 4.0f;
    private static final int NUM_COLORS = 10;
    private static final int[][] COLORS;
    private static final String LABEL_FORMAT = "%.2f%% confidence (index: %d)";
    @NotNull
    public static final Companion Companion;

    public void draw(@Nullable Canvas canvas) {
        StringCompanionObject stringCompanionObject;
        boolean bl;
        int n;
        if (this.detectedObject.getTrackingId() == null) {
            n = 0;
        } else {
            Integer n2 = this.detectedObject.getTrackingId();
            Intrinsics.checkNotNull((Object)n2);
            int n3 = n2 % 10;
            boolean bl2 = false;
            n = Math.abs(n3);
        }
        int colorID = n;
        float textWidth = this.textPaints[colorID].measureText("Tracking ID: " + this.detectedObject.getTrackingId());
        float lineHeight = 58.0f;
        float yLabelOffset = -lineHeight;
        for (DetectedObject.Label label : this.detectedObject.getLabels()) {
            Paint paint = this.textPaints[colorID];
            DetectedObject.Label label2 = label;
            Intrinsics.checkNotNullExpressionValue((Object)label2, (String)"label");
            float f = paint.measureText(label2.getText());
            bl = false;
            textWidth = Math.max(textWidth, f);
            Paint paint2 = this.textPaints[colorID];
            StringCompanionObject stringCompanionObject2 = StringCompanionObject.INSTANCE;
            Locale locale = Locale.US;
            String string = LABEL_FORMAT;
            stringCompanionObject = new StringCompanionObject[]{Float.valueOf(label.getConfidence() * (float)100), Integer.valueOf(label.getIndex())};
            boolean bl3 = false;
            StringCompanionObject stringCompanionObject3 = stringCompanionObject;
            String string2 = String.format(locale, string, Arrays.copyOf(stringCompanionObject3, ((Object[])stringCompanionObject3).length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"java.lang.String.format(locale, format, *args)");
            f = paint2.measureText(string2);
            bl = false;
            textWidth = Math.max(textWidth, f);
            yLabelOffset -= (float)2 * lineHeight;
        }
        RectF rect = new RectF(this.detectedObject.getBoundingBox());
        float x0 = this.translateX(rect.left);
        float x1 = this.translateX(rect.right);
        bl = false;
        rect.left = Math.min(x0, x1);
        bl = false;
        rect.right = Math.max(x0, x1);
        rect.top = this.translateY(rect.top);
        rect.bottom = this.translateY(rect.bottom);
        Canvas canvas2 = canvas;
        if (canvas2 != null) {
            canvas2.drawRect(rect, this.boxPaints[colorID]);
        }
        Canvas canvas3 = canvas;
        if (canvas3 != null) {
            canvas3.drawRect(rect.left - 4.0f, rect.top + yLabelOffset, rect.left + textWidth + 8.0f, rect.top, this.labelPaints[colorID]);
        }
        yLabelOffset += 54.0f;
        Canvas canvas4 = canvas;
        if (canvas4 != null) {
            canvas4.drawText("Tracking ID: " + this.detectedObject.getTrackingId(), rect.left, rect.top + yLabelOffset, this.textPaints[colorID]);
        }
        yLabelOffset += lineHeight;
        for (DetectedObject.Label label : this.detectedObject.getLabels()) {
            Canvas canvas5 = canvas;
            if (canvas5 != null) {
                StringBuilder stringBuilder = new StringBuilder();
                DetectedObject.Label label3 = label;
                Intrinsics.checkNotNullExpressionValue((Object)label3, (String)"label");
                canvas5.drawText(stringBuilder.append(label3.getText()).append(" (index: ").append(label.getIndex()).append(")").toString(), rect.left, rect.top + yLabelOffset, this.textPaints[colorID]);
            }
            yLabelOffset += lineHeight;
            Canvas canvas6 = canvas;
            if (canvas6 != null) {
                stringCompanionObject = StringCompanionObject.INSTANCE;
                Locale locale = Locale.US;
                String string = LABEL_FORMAT;
                Object[] objectArray = new Object[2];
                DetectedObject.Label label4 = label;
                Intrinsics.checkNotNullExpressionValue((Object)label4, (String)"label");
                objectArray[0] = Float.valueOf(label4.getConfidence() * (float)100);
                objectArray[1] = label.getIndex();
                Object[] objectArray2 = objectArray;
                boolean bl4 = false;
                String string3 = String.format(locale, string, Arrays.copyOf(objectArray2, objectArray2.length));
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"java.lang.String.format(locale, format, *args)");
                canvas6.drawText(string3, rect.left, rect.top + yLabelOffset, this.textPaints[colorID]);
            }
            yLabelOffset += lineHeight;
        }
    }

    /*
     * WARNING - void declaration
     */
    public ObjectGraphic(@NotNull GraphicOverlay overlay, @NotNull DetectedObject detectedObject) {
        int it;
        Paint paint;
        Paint[] paintArray;
        int n;
        Intrinsics.checkNotNullParameter((Object)overlay, (String)"overlay");
        Intrinsics.checkNotNullParameter((Object)detectedObject, (String)"detectedObject");
        super(overlay);
        this.detectedObject = detectedObject;
        int n2 = this.numColors = ((Object[])COLORS).length;
        ObjectGraphic objectGraphic = this;
        Paint[] paintArray2 = new Paint[n2];
        int n3 = 0;
        while (n3 < n2) {
            int n4 = n3;
            n = n3++;
            paintArray = paintArray2;
            boolean bl = false;
            paintArray[n] = paint = new Paint();
        }
        paintArray = paintArray2;
        objectGraphic.boxPaints = paintArray;
        n2 = this.numColors;
        objectGraphic = this;
        paintArray2 = new Paint[n2];
        n3 = 0;
        while (n3 < n2) {
            it = n3;
            n = n3++;
            paintArray = paintArray2;
            boolean bl = false;
            paintArray[n] = paint = new Paint();
        }
        paintArray = paintArray2;
        objectGraphic.textPaints = paintArray;
        n2 = this.numColors;
        objectGraphic = this;
        paintArray2 = new Paint[n2];
        n3 = 0;
        while (n3 < n2) {
            it = n3;
            n = n3++;
            paintArray = paintArray2;
            boolean bl = false;
            paintArray[n] = paint = new Paint();
        }
        paintArray = paintArray2;
        objectGraphic.labelPaints = paintArray;
        n2 = 0;
        int n5 = this.numColors;
        while (n2 < n5) {
            void i;
            this.textPaints[i] = new Paint();
            this.textPaints[i].setColor(COLORS[i][0]);
            this.textPaints[i].setTextSize(54.0f);
            this.boxPaints[i] = new Paint();
            this.boxPaints[i].setColor(COLORS[i][1]);
            this.boxPaints[i].setStyle(Paint.Style.STROKE);
            this.boxPaints[i].setStrokeWidth(4.0f);
            this.labelPaints[i] = new Paint();
            this.labelPaints[i].setColor(COLORS[i][1]);
            this.labelPaints[i].setStyle(Paint.Style.FILL);
            ++i;
        }
    }

    static {
        Companion = new Companion(null);
        COLORS = new int[][]{{-16777216, -1}, {-1, -65281}, {-16777216, -3355444}, {-1, -65536}, {-1, -16776961}, {-1, -12303292}, {-16777216, -16711681}, {-16777216, -256}, {-1, -16777216}, {-16777216, -16711936}};
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u0015\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\fX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/jakebarnby/simpleml/objects/view/ObjectGraphic$Companion;", "", "()V", "COLORS", "", "", "[[I", "LABEL_FORMAT", "", "NUM_COLORS", "", "STROKE_WIDTH", "", "TEXT_SIZE", "simpleml-objects_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

