/*
 * Decompiled with CFR 0.152.
 */
package com.jackandphantom.blurimage;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.os.AsyncTask;
import android.renderscript.Allocation;
import android.renderscript.Element;
import android.renderscript.RenderScript;
import android.renderscript.ScriptIntrinsicBlur;
import android.support.annotation.NonNull;
import android.widget.ImageView;
import java.lang.ref.WeakReference;

public class BlurImage {
    private static final float BITMAP_SCALE = 0.3f;
    private static final float BLUR_RADIUS = 7.0f;
    private Bitmap image;
    private Context context;
    private float intensity = 8.0f;
    private float MAX_RADIUS = 25.0f;
    private float MIN_RADIUS = 0.0f;
    private boolean async = false;

    BlurImage(Context context) {
        this.context = context;
    }

    private Bitmap blur() {
        if (this.image == null) {
            return this.image;
        }
        int width = Math.round(this.image.getWidth());
        int height = Math.round(this.image.getHeight());
        Bitmap input = Bitmap.createScaledBitmap((Bitmap)this.image, (int)width, (int)height, (boolean)false);
        Bitmap output = Bitmap.createBitmap((Bitmap)input);
        RenderScript rs = RenderScript.create((Context)this.context);
        ScriptIntrinsicBlur intrinsicBlur = ScriptIntrinsicBlur.create((RenderScript)rs, (Element)Element.U8_4((RenderScript)rs));
        Allocation inputallocation = Allocation.createFromBitmap((RenderScript)rs, (Bitmap)input);
        Allocation outputallocation = Allocation.createFromBitmap((RenderScript)rs, (Bitmap)output);
        intrinsicBlur.setRadius(this.intensity);
        intrinsicBlur.setInput(inputallocation);
        intrinsicBlur.forEach(outputallocation);
        outputallocation.copyTo(output);
        return output;
    }

    @NonNull
    public static BlurImage with(Context context) {
        return new BlurImage(context);
    }

    public BlurImage load(Bitmap bitmap) {
        this.image = bitmap;
        return this;
    }

    public BlurImage load(int res) {
        this.image = BitmapFactory.decodeResource((Resources)this.context.getResources(), (int)res);
        return this;
    }

    public BlurImage intensity(float intensity) {
        this.intensity = intensity < this.MAX_RADIUS && intensity > 0.0f ? intensity : this.MAX_RADIUS;
        return this;
    }

    public BlurImage Async(boolean async) {
        this.async = async;
        return this;
    }

    public void into(ImageView imageView) {
        if (this.async) {
            new AsyncBlurImage(imageView).execute(new Void[0]);
        } else {
            try {
                imageView.setImageBitmap(this.blur());
            }
            catch (NullPointerException ex) {
                ex.printStackTrace();
            }
        }
    }

    public Bitmap getImageBlur() {
        return this.blur();
    }

    private class AsyncBlurImage
    extends AsyncTask<Void, Void, Bitmap> {
        private WeakReference<ImageView> weakReference;

        public AsyncBlurImage(ImageView image) {
            this.weakReference = new WeakReference<ImageView>(image);
        }

        protected Bitmap doInBackground(Void ... voids) {
            return BlurImage.this.blur();
        }

        protected void onPostExecute(Bitmap bitmap) {
            ImageView imageView = (ImageView)this.weakReference.get();
            if (imageView != null && bitmap != null) {
                imageView.setImageBitmap(bitmap);
            }
        }
    }
}

