/*
 * Decompiled with CFR 0.152.
 */
package com.jackandphantom.androidlikebutton;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.animation.TimeInterpolator;
import android.content.ContentResolver;
import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.provider.MediaStore;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.util.Property;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.AccelerateDecelerateInterpolator;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.OvershootInterpolator;
import android.widget.FrameLayout;
import android.widget.ImageView;
import com.jackandphantom.androidlikebutton.AndroidCircleView;
import com.jackandphantom.androidlikebutton.AndroidDotView;
import com.jackandphantom.androidlikebutton.R;
import java.io.IOException;

public class AndroidLikeButton
extends FrameLayout
implements View.OnClickListener {
    private ImageView star;
    private AndroidCircleView androidCircleView;
    private AndroidDotView androidDotView;
    private boolean isChecked;
    private AnimatorSet animatorSet;
    private int dotColor1;
    private int dotColor2;
    private int circleStartColor;
    private int circleEndColor;
    private int startIcon;
    private int endIcon;
    private boolean isLiked;
    private Context context;
    private Bitmap likeBitmap;
    private Bitmap unlikeBitmap;
    private boolean dotActive;
    private boolean circleActive;
    private OnLikeEventListener onLikeEventListener;

    public AndroidLikeButton(@NonNull Context context) {
        super(context);
        this.context = context;
    }

    public AndroidLikeButton(@NonNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
        this.context = context;
    }

    public AndroidLikeButton(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.context = context;
        TypedArray array = context.obtainStyledAttributes(attrs, R.styleable.AndroidLikeButton);
        this.dotColor1 = array.getColor(R.styleable.AndroidLikeButton_dot_color_1, 0);
        this.dotColor2 = array.getColor(R.styleable.AndroidLikeButton_dot_color_2, 0);
        this.circleEndColor = array.getColor(R.styleable.AndroidLikeButton_circle_endColor, 0);
        this.circleStartColor = array.getColor(R.styleable.AndroidLikeButton_circle_startColor, 0);
        this.startIcon = array.getResourceId(R.styleable.AndroidLikeButton_like_icon, 0);
        this.endIcon = array.getResourceId(R.styleable.AndroidLikeButton_unlike_icon, 0);
        this.isLiked = array.getBoolean(R.styleable.AndroidLikeButton_liked, false);
        this.dotActive = array.getBoolean(R.styleable.AndroidLikeButton_dot_active, true);
        this.circleActive = array.getBoolean(R.styleable.AndroidLikeButton_circle_active, true);
        array.recycle();
        this.init();
    }

    private void init() {
        View view = LayoutInflater.from((Context)this.getContext()).inflate(R.layout.like_layout, (ViewGroup)this, true);
        this.androidCircleView = (AndroidCircleView)view.findViewById(R.id.circleView);
        this.star = (ImageView)view.findViewById(R.id.starImg);
        this.androidDotView = (AndroidDotView)view.findViewById(R.id.dotView);
        this.androidCircleView.setEND_COLOR(this.circleEndColor);
        this.androidCircleView.setStartColor(this.circleStartColor);
        this.androidDotView.setDotColor1(this.dotColor1);
        this.androidDotView.setDotColor2(this.dotColor2);
        this.androidCircleView.setIsActive(this.circleActive);
        this.androidDotView.setDotActive(this.dotActive);
        if (this.startIcon != 0 && this.endIcon != 0) {
            this.likeBitmap = this.getBitmapFromResId(this.startIcon);
            this.unlikeBitmap = this.getBitmapFromResId(this.endIcon);
            this.setLikeButtonImage();
        }
        this.setOnClickListener(this);
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        int actualWidth = w / 2;
        int actualHeight = h / 2;
        this.setImageView(actualWidth, actualHeight);
    }

    public void setOnLikeEventListener(OnLikeEventListener onLikeEventListener) {
        this.onLikeEventListener = onLikeEventListener;
    }

    public void onClick(View view) {
        this.isChecked = !this.isChecked;
        this.star.setImageBitmap(this.isChecked ? this.likeBitmap : this.unlikeBitmap);
        if (this.animatorSet != null) {
            this.animatorSet.cancel();
        }
        if (this.isChecked) {
            this.star.animate().cancel();
            this.star.setScaleX(0.0f);
            this.star.setScaleY(0.0f);
            this.androidCircleView.setInnerCircleRadiusProgress(0.0f);
            this.androidCircleView.setProgress(0.0f);
            this.androidDotView.setCurrentProgress(0.0f);
            this.animatorSet = new AnimatorSet();
            ObjectAnimator outerCircleAnimator = ObjectAnimator.ofFloat((Object)((Object)this.androidCircleView), (String)"Progress", (float[])new float[]{0.1f, 1.0f});
            outerCircleAnimator.setDuration(250L);
            outerCircleAnimator.setInterpolator((TimeInterpolator)new DecelerateInterpolator());
            ObjectAnimator innerCircleAnimator = ObjectAnimator.ofFloat((Object)((Object)this.androidCircleView), (String)"InnerCircleRadiusProgress", (float[])new float[]{0.1f, 1.0f});
            innerCircleAnimator.setDuration(200L);
            innerCircleAnimator.setStartDelay(200L);
            innerCircleAnimator.setInterpolator((TimeInterpolator)new DecelerateInterpolator());
            ObjectAnimator starScaleYAnimator = ObjectAnimator.ofFloat((Object)this.star, (Property)ImageView.SCALE_Y, (float[])new float[]{0.2f, 1.0f});
            starScaleYAnimator.setDuration(350L);
            starScaleYAnimator.setStartDelay(250L);
            starScaleYAnimator.setInterpolator((TimeInterpolator)new OvershootInterpolator());
            ObjectAnimator starScaleXAnimator = ObjectAnimator.ofFloat((Object)this.star, (Property)ImageView.SCALE_X, (float[])new float[]{0.2f, 1.0f});
            starScaleXAnimator.setDuration(350L);
            starScaleXAnimator.setStartDelay(250L);
            starScaleXAnimator.setInterpolator((TimeInterpolator)new OvershootInterpolator());
            ObjectAnimator dotsAnimator = ObjectAnimator.ofFloat((Object)((Object)this.androidDotView), (String)"CurrentProgress", (float[])new float[]{0.1f, 1.0f});
            dotsAnimator.setDuration(900L);
            dotsAnimator.setStartDelay(50L);
            dotsAnimator.setInterpolator((TimeInterpolator)new AccelerateDecelerateInterpolator());
            this.animatorSet.playTogether(new Animator[]{outerCircleAnimator, innerCircleAnimator, starScaleYAnimator, starScaleXAnimator, dotsAnimator});
            this.animatorSet.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

                public void onAnimationCancel(Animator animation) {
                    AndroidLikeButton.this.androidCircleView.setInnerCircleRadiusProgress(0.0f);
                    AndroidLikeButton.this.androidCircleView.setProgress(0.0f);
                    AndroidLikeButton.this.androidDotView.setCurrentProgress(0.0f);
                    AndroidLikeButton.this.star.setScaleX(1.0f);
                    AndroidLikeButton.this.star.setScaleY(1.0f);
                }
            });
            this.animatorSet.start();
            if (this.onLikeEventListener != null) {
                this.onLikeEventListener.onLikeClicked(this);
            }
        } else if (this.onLikeEventListener != null) {
            this.onLikeEventListener.onUnlikeClicked(this);
        }
    }

    public boolean onTouchEvent(MotionEvent event) {
        switch (event.getAction()) {
            case 0: {
                this.star.animate().scaleX(0.7f).scaleY(0.7f).setDuration(150L).setInterpolator((TimeInterpolator)new DecelerateInterpolator());
                this.setPressed(true);
                break;
            }
            case 2: {
                boolean isInside;
                float x = event.getX();
                float y = event.getY();
                boolean bl = isInside = x > 0.0f && x < (float)this.getWidth() && y > 0.0f && y < (float)this.getHeight();
                if (this.isPressed() == isInside) break;
                this.setPressed(isInside);
                break;
            }
            case 1: {
                this.star.animate().scaleX(1.0f).scaleY(1.0f).setInterpolator((TimeInterpolator)new DecelerateInterpolator());
                if (!this.isPressed()) break;
                this.performClick();
                this.setPressed(false);
            }
        }
        return true;
    }

    public void setDotColor(int startColor, int endColor) {
        this.dotColor1 = startColor;
        this.dotColor2 = endColor;
        this.androidDotView.setAllDotColor(startColor, endColor);
    }

    public void setCircleColor(int startColor, int endColor) {
        this.circleStartColor = startColor;
        this.circleEndColor = endColor;
        this.androidCircleView.setAllColor(startColor, endColor);
    }

    public void setDotActive(boolean isActive) {
        this.dotActive = isActive;
        this.androidDotView.setDotActive(this.dotActive);
    }

    public void setCircleActive(boolean isActive) {
        this.circleActive = isActive;
        this.androidCircleView.setIsActive(this.circleActive);
    }

    private void setImageView(int width, int height) {
        this.star.getLayoutParams().width = width;
        this.star.getLayoutParams().height = height;
        this.androidCircleView.setWidthAndHeight(width, height);
        this.androidDotView.setWidthAndHeight(width, height);
    }

    public void setLikeIcon(int resId) {
        this.likeBitmap = this.getBitmapFromResId(resId);
        this.setLikeButtonImage();
    }

    public void setUnlikeIcon(int resId) {
        this.unlikeBitmap = this.getBitmapFromResId(resId);
        this.setLikeButtonImage();
    }

    public void setLikeIcon(Bitmap bitmap) {
        this.likeBitmap = bitmap;
        this.setLikeButtonImage();
    }

    public void setUnlikeIcon(Bitmap bitmap) {
        this.unlikeBitmap = bitmap;
        this.setLikeButtonImage();
    }

    public void setLikeIcon(Uri uri) {
        this.likeBitmap = this.getImageFromUri(uri);
        this.setLikeButtonImage();
    }

    public void setUnlikeIcon(Uri uri) {
        this.unlikeBitmap = this.getImageFromUri(uri);
        this.setLikeButtonImage();
    }

    private Bitmap getBitmapFromResId(int resId) {
        return BitmapFactory.decodeResource((Resources)this.context.getResources(), (int)resId);
    }

    private void setLikeButtonImage() {
        this.isChecked = this.isLiked;
        if (this.isLiked) {
            this.star.setImageBitmap(this.likeBitmap);
        } else {
            this.star.setImageBitmap(this.unlikeBitmap);
        }
    }

    public void setCurrentlyLiked(boolean isLiked) {
        this.isLiked = isLiked;
        this.isChecked = isLiked;
        this.setLikeButtonImage();
    }

    private Bitmap getDrawableToBitmap(Drawable drawable) {
        if (drawable == null) {
            return null;
        }
        Bitmap bitmap = Bitmap.createBitmap((int)drawable.getIntrinsicWidth(), (int)drawable.getIntrinsicHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(bitmap);
        drawable.setBounds(0, 0, bitmap.getWidth(), bitmap.getHeight());
        drawable.draw(canvas);
        return bitmap;
    }

    private Bitmap getImageFromUri(Uri uri) {
        Bitmap temp = null;
        try {
            temp = MediaStore.Images.Media.getBitmap((ContentResolver)this.context.getContentResolver(), (Uri)uri);
        }
        catch (IOException exception) {
            exception.printStackTrace();
        }
        return temp;
    }

    public Bitmap getLikeBitmap() {
        return this.likeBitmap;
    }

    public Bitmap getUnlikeBitmap() {
        return this.unlikeBitmap;
    }

    public static interface OnLikeEventListener {
        public void onLikeClicked(AndroidLikeButton var1);

        public void onUnlikeClicked(AndroidLikeButton var1);
    }
}

