/*
 * Decompiled with CFR 0.152.
 */
package com.jackandphantom.androidlikebutton;

import android.animation.ArgbEvaluator;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.Xfermode;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.view.View;

public class AndroidCircleView
extends View {
    private int StartColor = -43230;
    private int END_COLOR = -16121;
    private ArgbEvaluator argbEvaluator = new ArgbEvaluator();
    private Paint circlePaint = new Paint();
    private Paint maskPaint = new Paint();
    private Bitmap tempBitmap;
    private Canvas tempCanvas;
    private float outerCircleRadiusProgress = 0.0f;
    private float innerCircleRadiusProgress = 0.0f;
    private int maxCircleSize;
    private int width;
    private int height;
    private boolean isActive = true;
    private boolean changeDimensiion = false;

    public AndroidCircleView(Context context) {
        super(context);
        this.init();
    }

    public AndroidCircleView(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public AndroidCircleView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init();
    }

    private void init() {
        this.circlePaint.setStyle(Paint.Style.FILL);
        this.maskPaint.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.CLEAR));
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        this.valueInit(w);
    }

    private void valueInit(int width) {
        this.maxCircleSize = width / 2;
        this.tempBitmap = Bitmap.createBitmap((int)width, (int)width, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        this.tempCanvas = new Canvas(this.tempBitmap);
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        this.tempCanvas.drawCircle((float)(this.getWidth() / 2), (float)(this.getHeight() / 2), this.outerCircleRadiusProgress * (float)this.maxCircleSize, this.circlePaint);
        this.tempCanvas.drawCircle((float)(this.getWidth() / 2), (float)(this.getHeight() / 2), this.innerCircleRadiusProgress * (float)this.maxCircleSize, this.maskPaint);
        if (this.isActive) {
            canvas.drawBitmap(this.tempBitmap, 0.0f, 0.0f, null);
        }
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        if (this.changeDimensiion) {
            this.setMeasuredDimension(this.width, this.height);
        } else {
            this.width = AndroidCircleView.getDefaultSize((int)this.getSuggestedMinimumWidth(), (int)widthMeasureSpec);
            this.height = AndroidCircleView.getDefaultSize((int)this.getSuggestedMinimumHeight(), (int)heightMeasureSpec);
            this.setMeasuredDimension(this.width, this.height);
        }
    }

    public void setProgress(float value) {
        this.outerCircleRadiusProgress = value;
        this.circlePaint.setColor(((Integer)this.argbEvaluator.evaluate(value, (Object)this.StartColor, (Object)this.END_COLOR)).intValue());
        this.invalidate();
    }

    public float getProgress() {
        return this.outerCircleRadiusProgress;
    }

    public void setInnerCircleRadiusProgress(float value) {
        this.innerCircleRadiusProgress = value;
        this.invalidate();
    }

    float getInnerCircleRadiusProgress() {
        return this.innerCircleRadiusProgress;
    }

    void setStartColor(int color) {
        if (color != 0) {
            this.StartColor = color;
        }
    }

    void setEND_COLOR(int color) {
        if (color != 0) {
            this.END_COLOR = color;
        }
    }

    void setWidthAndHeight(int width, int height) {
        this.width = width * 2;
        this.height = height * 2;
        this.valueInit(width * 2);
        this.changeDimensiion = true;
        this.requestLayout();
    }

    void setIsActive(boolean isActive) {
        this.isActive = isActive;
    }

    void setAllColor(int startColor, int endColor) {
        this.StartColor = startColor;
        this.END_COLOR = endColor;
    }
}

