/*
 * Decompiled with CFR 0.152.
 */
package com.j256.ormlite.jdbc.db;

import com.j256.ormlite.db.BaseDatabaseType;
import com.j256.ormlite.field.FieldType;
import java.util.List;

public class NetezzaDatabaseType
extends BaseDatabaseType {
    private static final String DATABASE_URL_PORTION = "netezza";
    private static final String DRIVER_CLASS_NAME = "org.netezza.Driver";
    private static final String DATABASE_NAME = "Netezza";

    public boolean isDatabaseUrlThisType(String url, String dbTypePart) {
        return DATABASE_URL_PORTION.equals(dbTypePart);
    }

    protected String[] getDriverClassNames() {
        return new String[]{DRIVER_CLASS_NAME};
    }

    public String getDatabaseName() {
        return DATABASE_NAME;
    }

    protected void appendByteType(StringBuilder sb, FieldType fieldType, int fieldWidth) {
        sb.append("BYTEINT");
    }

    protected void configureGeneratedIdSequence(StringBuilder sb, FieldType fieldType, List<String> statementsBefore, List<String> additionalArgs, List<String> queriesAfter) {
        String sequenceName = fieldType.getGeneratedIdSequence();
        StringBuilder seqSb = new StringBuilder(64);
        seqSb.append("CREATE SEQUENCE ");
        this.appendEscapedEntityName(seqSb, sequenceName);
        statementsBefore.add(seqSb.toString());
        this.configureId(sb, fieldType, statementsBefore, additionalArgs, queriesAfter);
    }

    public void dropColumnArg(FieldType fieldType, List<String> statementsBefore, List<String> statementsAfter) {
        if (fieldType.isGeneratedIdSequence()) {
            StringBuilder sb = new StringBuilder(64);
            sb.append("DROP SEQUENCE ");
            this.appendEscapedEntityName(sb, fieldType.getGeneratedIdSequence());
            statementsAfter.add(sb.toString());
        }
    }

    public void appendEscapedEntityName(StringBuilder sb, String name) {
        sb.append('\"').append(name).append('\"');
    }

    public boolean isIdSequenceNeeded() {
        return true;
    }

    public void appendSelectNextValFromSequence(StringBuilder sb, String sequenceName) {
        sb.append("SELECT NEXT VALUE FOR ");
        this.appendEscapedWord(sb, sequenceName);
    }
}

