/*
 * Decompiled with CFR 0.152.
 */
package com.j256.ormlite.jdbc.db;

import com.j256.ormlite.db.BaseDatabaseType;
import com.j256.ormlite.field.FieldType;
import java.util.List;

public class H2DatabaseType
extends BaseDatabaseType {
    private static final String DATABASE_URL_PORTION = "h2";
    private static final String DRIVER_CLASS_NAME = "org.h2.Driver";
    private static final String DATABASE_NAME = "H2";

    public boolean isDatabaseUrlThisType(String url, String dbTypePart) {
        return DATABASE_URL_PORTION.equals(dbTypePart);
    }

    protected String[] getDriverClassNames() {
        return new String[]{DRIVER_CLASS_NAME};
    }

    public String getDatabaseName() {
        return DATABASE_NAME;
    }

    protected void configureGeneratedId(String tableName, StringBuilder sb, FieldType fieldType, List<String> statementsBefore, List<String> statementsAfter, List<String> additionalArgs, List<String> queriesAfter) {
        sb.append("AUTO_INCREMENT ");
        this.configureId(sb, fieldType, statementsBefore, additionalArgs, queriesAfter);
    }

    public void appendLimitValue(StringBuilder sb, long limit, Long offset) {
        sb.append("LIMIT ");
        if (offset != null) {
            sb.append(offset).append(',');
        }
        sb.append(limit).append(' ');
    }

    public boolean isOffsetLimitArgument() {
        return true;
    }

    public void appendOffsetValue(StringBuilder sb, long offset) {
        throw new IllegalStateException("Offset is part of the LIMIT in database type " + ((Object)((Object)this)).getClass());
    }

    public boolean isTruncateSupported() {
        return true;
    }

    public boolean isCreateIfNotExistsSupported() {
        return true;
    }
}

