/*
 * Decompiled with CFR 0.152.
 */
package com.j256.ormlite.spring;

import com.j256.ormlite.dao.BaseDaoImpl;
import com.j256.ormlite.support.ConnectionSource;
import com.j256.ormlite.table.DatabaseTableConfig;
import com.j256.ormlite.table.TableUtils;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TableCreator {
    public static final String AUTO_CREATE_TABLES = "ormlite.auto.create.tables";
    public static final String AUTO_DROP_TABLES = "ormlite.auto.drop.tables";
    private ConnectionSource connectionSource;
    private List<BaseDaoImpl<?, ?>> configuredDaos;
    private Set<DatabaseTableConfig<?>> createdClasses = new HashSet();

    public void initialize() throws Exception {
        if (!Boolean.parseBoolean(System.getProperty(AUTO_CREATE_TABLES))) {
            return;
        }
        if (this.configuredDaos == null) {
            throw new IllegalStateException("configuredDaos was not set in " + this.getClass().getSimpleName());
        }
        for (BaseDaoImpl<?, ?> dao : this.configuredDaos) {
            Class<?> clazz = dao.getDataClass();
            try {
                DatabaseTableConfig<?> tableConfig = dao.getTableConfig();
                TableUtils.createTable(this.connectionSource, tableConfig);
                this.createdClasses.add(tableConfig);
            }
            catch (Exception e) {
                System.err.println("Was unable to auto-create table for " + clazz);
                e.printStackTrace();
            }
        }
    }

    public void destroy() throws Exception {
        if (!Boolean.parseBoolean(System.getProperty(AUTO_DROP_TABLES))) {
            return;
        }
        for (DatabaseTableConfig<?> tableConfig : this.createdClasses) {
            try {
                TableUtils.dropTable(this.connectionSource, tableConfig, false);
            }
            catch (Exception e) {
                System.err.println("Was unable to auto-drop table for " + tableConfig.getDataClass());
                e.printStackTrace();
            }
        }
        this.createdClasses.clear();
    }

    public void setConnectionSource(ConnectionSource dataSource) {
        this.connectionSource = dataSource;
    }

    public void setConfiguredDaos(List<BaseDaoImpl<?, ?>> configuredDaos) {
        this.configuredDaos = configuredDaos;
    }
}

