/*
 * Decompiled with CFR 0.152.
 */
package com.j256.ormlite.field;

import com.j256.ormlite.db.DatabaseType;
import com.j256.ormlite.field.DataType;
import com.j256.ormlite.field.DatabaseFieldConfig;
import com.j256.ormlite.field.FieldConverter;
import com.j256.ormlite.field.SqlType;
import com.j256.ormlite.misc.SqlExceptionUtil;
import com.j256.ormlite.support.DatabaseResults;
import com.j256.ormlite.table.DatabaseTableConfig;
import com.j256.ormlite.table.TableInfo;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FieldType {
    public static final String FOREIGN_ID_FIELD_SUFFIX = "_id";
    public static final int MAX_FOREIGN_RECURSE_LEVEL = 10;
    private final String tableName;
    private final Field field;
    private final String fieldName;
    private final String dbColumnName;
    private final DataType dataType;
    private final Object defaultValue;
    private final int width;
    private final boolean canBeNull;
    private final boolean isId;
    private final boolean isGeneratedId;
    private final String generatedIdSequence;
    private final FieldConverter fieldConverter;
    private final TableInfo<?> foreignTableInfo;
    private final Method fieldGetMethod;
    private final Method fieldSetMethod;
    private final Map<String, Enum<?>> enumStringMap;
    private final Map<Integer, Enum<?>> enumValueMap;
    private final Enum<?> unknownEnumVal;
    private final boolean throwIfNull;
    private final String format;
    private final boolean unique;
    private String indexName;
    private String uniqueIndexName;

    public FieldType(DatabaseType databaseType, String tableName, Field field, DatabaseFieldConfig fieldConfig, int recurseLevel) throws SQLException {
        DataType dataType;
        this.tableName = tableName;
        this.field = field;
        this.fieldName = field.getName();
        if (fieldConfig.getDataType() == DataType.UNKNOWN) {
            dataType = DataType.lookupClass(field.getType());
        } else {
            dataType = fieldConfig.getDataType();
            if (!dataType.isValidForType(field.getType())) {
                throw new IllegalArgumentException("Field class " + field.getType() + " for field " + this + " is not valid for data type " + dataType);
            }
        }
        String defaultFieldName = field.getName();
        if (fieldConfig.isForeign()) {
            if (recurseLevel < 10) {
                TableInfo foreignInfo;
                if (dataType.isPrimitive()) {
                    throw new IllegalArgumentException("Field " + this + " is a primitive class " + field.getType() + " but marked as foreign");
                }
                DatabaseTableConfig<?> tableConfig = fieldConfig.getForeignTableConfig();
                if (tableConfig == null) {
                    tableConfig = DatabaseTableConfig.fromClass(databaseType, field.getType(), recurseLevel + 1);
                }
                if ((foreignInfo = new TableInfo(databaseType, tableConfig)).getIdField() == null) {
                    throw new IllegalArgumentException("Foreign field " + field.getType() + " does not have id field");
                }
                this.foreignTableInfo = foreignInfo;
                defaultFieldName = defaultFieldName + FOREIGN_ID_FIELD_SUFFIX;
                dataType = foreignInfo.getIdField().getDataType();
            } else {
                this.foreignTableInfo = null;
            }
        } else {
            if (dataType == DataType.UNKNOWN) {
                throw new IllegalArgumentException("ORMLite does not know how to store field class " + field.getType() + " for field " + this);
            }
            this.foreignTableInfo = null;
        }
        this.dbColumnName = fieldConfig.getColumnName() == null ? defaultFieldName : fieldConfig.getColumnName();
        this.dataType = dataType;
        this.width = fieldConfig.getWidth();
        this.canBeNull = fieldConfig.isCanBeNull();
        if (fieldConfig.isId()) {
            if (fieldConfig.isGeneratedId() || fieldConfig.getGeneratedIdSequence() != null) {
                throw new IllegalArgumentException("Must specify one of id, generatedId, and generatedIdSequence with " + field.getName());
            }
            this.isId = true;
            this.isGeneratedId = false;
            this.generatedIdSequence = null;
        } else if (fieldConfig.isGeneratedId()) {
            if (fieldConfig.getGeneratedIdSequence() != null) {
                throw new IllegalArgumentException("Must specify one of id, generatedId, and generatedIdSequence with " + field.getName());
            }
            this.isId = true;
            this.isGeneratedId = true;
            this.generatedIdSequence = databaseType.isIdSequenceNeeded() ? databaseType.generateIdSequenceName(tableName, this) : null;
        } else if (fieldConfig.getGeneratedIdSequence() != null) {
            this.isId = true;
            this.isGeneratedId = true;
            String seqName = fieldConfig.getGeneratedIdSequence();
            if (databaseType.isEntityNamesMustBeUpCase()) {
                seqName = seqName.toUpperCase();
            }
            this.generatedIdSequence = seqName;
        } else {
            this.isId = false;
            this.isGeneratedId = false;
            this.generatedIdSequence = null;
        }
        if (this.isGeneratedId && !this.dataType.isValidGeneratedType()) {
            StringBuilder sb = new StringBuilder();
            sb.append("Generated-id field '").append(field.getName());
            sb.append("' in ").append(field.getDeclaringClass().getSimpleName());
            sb.append(" can't be type ").append(this.dataType);
            sb.append(".  Must be one of: ");
            for (Enum enum_ : DataType.values()) {
                if (!((DataType)enum_).isValidGeneratedType()) continue;
                sb.append(enum_).append(' ');
            }
            throw new IllegalArgumentException(sb.toString());
        }
        this.fieldConverter = databaseType.getFieldConverter(dataType);
        this.format = fieldConfig.getFormat();
        if (this.isId && this.foreignTableInfo != null) {
            throw new IllegalArgumentException("Id field " + field.getName() + " cannot also be a foreign object");
        }
        if (fieldConfig.isUseGetSet()) {
            this.fieldGetMethod = DatabaseFieldConfig.findGetMethod(field, true);
            this.fieldSetMethod = DatabaseFieldConfig.findSetMethod(field, true);
        } else {
            this.fieldGetMethod = null;
            this.fieldSetMethod = null;
        }
        if (dataType == DataType.ENUM_INTEGER || dataType == DataType.ENUM_STRING) {
            this.enumStringMap = new HashMap();
            this.enumValueMap = new HashMap();
            Enum[] constants = (Enum[])field.getType().getEnumConstants();
            if (constants == null) {
                throw new SQLException("Field " + field.getName() + " improperly configured as type " + dataType);
            }
            for (Enum enum_ : constants) {
                this.enumStringMap.put(enum_.name(), enum_);
                this.enumValueMap.put(enum_.ordinal(), enum_);
            }
            this.unknownEnumVal = fieldConfig.getUnknownEnumvalue();
        } else {
            this.enumStringMap = null;
            this.enumValueMap = null;
            this.unknownEnumVal = null;
        }
        this.throwIfNull = fieldConfig.isThrowIfNull();
        if (this.throwIfNull && !dataType.isPrimitive()) {
            throw new SQLException("Field " + field.getName() + " must be a primitive if set with throwIfNull");
        }
        String defaultStr = fieldConfig.getDefaultValue();
        if (defaultStr == null || defaultStr.equals("")) {
            this.defaultValue = null;
        } else {
            if (this.isGeneratedId) {
                throw new SQLException("Field '" + field.getName() + "' cannot be a generatedId and have a default value '" + defaultStr + "'");
            }
            this.defaultValue = this.fieldConverter.parseDefaultString(this, defaultStr);
        }
        this.unique = fieldConfig.isUnique();
        this.indexName = fieldConfig.getIndexName();
        this.uniqueIndexName = fieldConfig.getUniqueIndexName();
        if (this.isId && !dataType.isAppropriateId()) {
            throw new SQLException("Field '" + field.getName() + "' is of data type " + dataType + " which cannot be the ID field");
        }
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public Class<?> getFieldType() {
        return this.field.getType();
    }

    public String getDbColumnName() {
        return this.dbColumnName;
    }

    public DataType getDataType() {
        return this.dataType;
    }

    public SqlType getSqlType() {
        return this.fieldConverter.getSqlType();
    }

    public Object getDefaultValue() {
        return this.defaultValue;
    }

    public int getWidth() {
        return this.width;
    }

    public boolean isCanBeNull() {
        return this.canBeNull;
    }

    public boolean isId() {
        return this.isId;
    }

    public boolean isGeneratedId() {
        return this.isGeneratedId;
    }

    public boolean isGeneratedIdSequence() {
        return this.generatedIdSequence != null;
    }

    public String getGeneratedIdSequence() {
        return this.generatedIdSequence;
    }

    public boolean isForeign() {
        return this.foreignTableInfo != null;
    }

    public TableInfo<?> getForeignTableInfo() {
        return this.foreignTableInfo;
    }

    public void assignField(Object data, Object val) throws SQLException {
        if (this.foreignTableInfo != null) {
            Object foreignId = this.extractJavaFieldValue(data);
            if (foreignId != null && foreignId.equals(val)) {
                return;
            }
            Object foreignObject = this.foreignTableInfo.createObject();
            this.foreignTableInfo.getIdField().assignField(foreignObject, val);
            val = foreignObject;
        }
        if (this.fieldSetMethod == null) {
            boolean accessible = this.field.isAccessible();
            if (!accessible) {
                this.field.setAccessible(true);
            }
            try {
                this.field.set(data, val);
            }
            catch (IllegalArgumentException e) {
                throw SqlExceptionUtil.create("Could not assign object '" + val + "' to field " + this, e);
            }
            catch (IllegalAccessException e) {
                throw SqlExceptionUtil.create("Could not assign object '" + val + "' to field " + this, e);
            }
            finally {
                if (!accessible) {
                    this.field.setAccessible(false);
                }
            }
        }
        try {
            this.fieldSetMethod.invoke(data, val);
        }
        catch (Exception e) {
            throw SqlExceptionUtil.create("Could not call " + this.fieldSetMethod + " on object with '" + val + "' for " + this, e);
        }
    }

    public Object assignIdValue(Object data, Number val) throws SQLException {
        Object idVal = this.dataType.convertIdNumber(val);
        if (idVal == null) {
            throw new SQLException("Invalid class " + this.dataType + " for sequence-id " + this);
        }
        this.assignField(data, idVal);
        return idVal;
    }

    public <FV> FV extractJavaFieldValue(Object object) throws SQLException {
        Object val;
        if (this.fieldGetMethod == null) {
            boolean accessible = this.field.isAccessible();
            try {
                if (!accessible) {
                    this.field.setAccessible(true);
                }
                val = this.field.get(object);
            }
            catch (Exception e) {
                throw SqlExceptionUtil.create("Could not get field value for " + this, e);
            }
            finally {
                if (!accessible) {
                    this.field.setAccessible(false);
                }
            }
        }
        try {
            val = this.fieldGetMethod.invoke(object, new Object[0]);
        }
        catch (Exception e) {
            throw SqlExceptionUtil.create("Could not call " + this.fieldGetMethod + " for " + this, e);
        }
        if (val == null) {
            return null;
        }
        if (this.foreignTableInfo != null) {
            val = this.foreignTableInfo.getIdField().extractJavaFieldValue(val);
        }
        Object converted = val;
        return (FV)converted;
    }

    public Object extractJavaFieldToSqlArgValue(Object object) throws SQLException {
        return this.convertJavaFieldToSqlArgValue(this.extractJavaFieldValue(object));
    }

    public <FV> FV convertJavaFieldToSqlArgValue(Object fieldVal) throws SQLException {
        if (fieldVal == null) {
            return null;
        }
        Object converted = fieldVal = this.fieldConverter.javaToSqlArg(this, fieldVal);
        return (FV)converted;
    }

    public FieldType getForeignIdField() throws SQLException {
        if (this.foreignTableInfo == null) {
            return null;
        }
        return this.foreignTableInfo.getIdField();
    }

    public boolean isEscapedValue() {
        return this.dataType.isEscapedValue();
    }

    public String getFormat() {
        return this.format;
    }

    public boolean isUnique() {
        return this.unique;
    }

    public String getIndexName() {
        return this.indexName;
    }

    public String getUniqueIndexName() {
        return this.uniqueIndexName;
    }

    public boolean isEscapeDefaultValue() {
        return this.dataType.isEscapeDefaultValue();
    }

    public boolean isComparable() {
        return this.dataType.isComparable();
    }

    public boolean isSelectArgRequired() {
        return this.dataType.isSelectArgRequired();
    }

    public <T> T resultToJava(DatabaseResults results, Map<String, Integer> columnPositions) throws SQLException {
        Integer dbColumnPos = columnPositions.get(this.dbColumnName);
        if (dbColumnPos == null) {
            dbColumnPos = results.findColumn(this.dbColumnName);
            columnPositions.put(this.dbColumnName, dbColumnPos);
        }
        if (this.dataType.isPrimitive()) {
            if (this.throwIfNull && results.isNull(dbColumnPos)) {
                throw new SQLException("Results value for primitive field '" + this.fieldName + "' was an invalid null value");
            }
        } else if (!this.fieldConverter.isStreamType() && results.isNull(dbColumnPos)) {
            return null;
        }
        Object converted = this.fieldConverter.resultToJava(this, results, dbColumnPos);
        return (T)converted;
    }

    public Enum<?> enumFromInt(int val) throws SQLException {
        Integer integerVal = new Integer(val);
        if (this.enumValueMap == null) {
            return this.enumVal(integerVal, null);
        }
        return this.enumVal(integerVal, this.enumValueMap.get(integerVal));
    }

    public Enum<?> enumFromString(String val) throws SQLException {
        if (this.enumStringMap == null) {
            return this.enumVal(val, null);
        }
        return this.enumVal(val, this.enumStringMap.get(val));
    }

    public static FieldType createFieldType(DatabaseType databaseType, String tableName, Field field, int recurseLevel) throws SQLException {
        DatabaseFieldConfig fieldConfig = DatabaseFieldConfig.fromField(databaseType, field);
        if (fieldConfig == null) {
            return null;
        }
        return new FieldType(databaseType, tableName, field, fieldConfig, recurseLevel);
    }

    public boolean equals(Object arg) {
        if (arg == null || arg.getClass() != this.getClass()) {
            return false;
        }
        FieldType other = (FieldType)arg;
        return this.field.equals(other.field);
    }

    public int hashCode() {
        return this.field.hashCode();
    }

    public String toString() {
        return this.getClass().getSimpleName() + ":name=" + this.field.getName() + ",class=" + this.field.getDeclaringClass().getSimpleName();
    }

    private Enum<?> enumVal(Object val, Enum<?> enumVal) throws SQLException {
        if (enumVal != null) {
            return enumVal;
        }
        if (this.unknownEnumVal == null) {
            throw new SQLException("Cannot get enum value of '" + val + "' for field " + this.field);
        }
        return this.unknownEnumVal;
    }
}

