/*
 * Decompiled with CFR 0.152.
 */
package com.j256.ormlite.jdbc;

import com.j256.ormlite.field.DataType;
import com.j256.ormlite.jdbc.TypeValMapper;
import com.j256.ormlite.support.DatabaseResults;
import java.io.InputStream;
import java.sql.Blob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Timestamp;

public class JdbcDatabaseResults
implements DatabaseResults {
    private final PreparedStatement preparedStmt;
    private final ResultSet resultSet;
    private ResultSetMetaData metaData = null;

    public JdbcDatabaseResults(PreparedStatement preparedStmt, ResultSet resultSet) {
        this.preparedStmt = preparedStmt;
        this.resultSet = resultSet;
    }

    public int getColumnCount() throws SQLException {
        if (this.metaData == null) {
            this.metaData = this.resultSet.getMetaData();
        }
        return this.metaData.getColumnCount();
    }

    public String getColumnName(int columnIndex) throws SQLException {
        if (this.metaData == null) {
            this.metaData = this.resultSet.getMetaData();
        }
        return this.metaData.getColumnName(columnIndex);
    }

    Number getIdColumnData(int columnIndex) throws SQLException {
        int typeVal;
        DataType dataType;
        if (this.metaData == null) {
            this.metaData = this.resultSet.getMetaData();
        }
        if ((dataType = TypeValMapper.getDataTypeForIdTypeVal(typeVal = this.metaData.getColumnType(columnIndex))) == null) {
            throw new SQLException("Unknown DataType for typeVal " + typeVal + " in column " + columnIndex);
        }
        Number id = dataType.resultToId(this, columnIndex);
        if (id == null) {
            String colName = "unknown";
            try {
                colName = this.getColumnName(columnIndex);
            }
            catch (SQLException e) {
                // empty catch block
            }
            throw new SQLException("Id column " + colName + " (#" + columnIndex + ") is invalid type " + dataType);
        }
        return id;
    }

    public int findColumn(String columnName) throws SQLException {
        return this.resultSet.findColumn(columnName);
    }

    public InputStream getBlobStream(int columnIndex) throws SQLException {
        Blob blob = this.resultSet.getBlob(columnIndex);
        if (blob == null) {
            return null;
        }
        return blob.getBinaryStream();
    }

    public boolean getBoolean(int columnIndex) throws SQLException {
        return this.resultSet.getBoolean(columnIndex);
    }

    public byte getByte(int columnIndex) throws SQLException {
        return this.resultSet.getByte(columnIndex);
    }

    public byte[] getBytes(int columnIndex) throws SQLException {
        return this.resultSet.getBytes(columnIndex);
    }

    public double getDouble(int columnIndex) throws SQLException {
        return this.resultSet.getDouble(columnIndex);
    }

    public float getFloat(int columnIndex) throws SQLException {
        return this.resultSet.getFloat(columnIndex);
    }

    public int getInt(int columnIndex) throws SQLException {
        return this.resultSet.getInt(columnIndex);
    }

    public long getLong(int columnIndex) throws SQLException {
        return this.resultSet.getLong(columnIndex);
    }

    public short getShort(int columnIndex) throws SQLException {
        return this.resultSet.getShort(columnIndex);
    }

    public String getString(int columnIndex) throws SQLException {
        return this.resultSet.getString(columnIndex);
    }

    public Timestamp getTimestamp(int columnIndex) throws SQLException {
        return this.resultSet.getTimestamp(columnIndex);
    }

    public boolean next() throws SQLException {
        if (this.resultSet.next()) {
            return true;
        }
        if (!this.preparedStmt.getMoreResults()) {
            return false;
        }
        return this.resultSet.next();
    }

    public boolean isNull(int columnIndex) throws SQLException {
        return this.resultSet.getObject(columnIndex) == null;
    }
}

