/*
 * Decompiled with CFR 0.152.
 */
package com.j256.ormlite.db;

import com.j256.ormlite.db.DatabaseType;
import com.j256.ormlite.db.Db2DatabaseType;
import com.j256.ormlite.db.DerbyEmbeddedDatabaseType;
import com.j256.ormlite.db.H2DatabaseType;
import com.j256.ormlite.db.HsqldbDatabaseType;
import com.j256.ormlite.db.MysqlDatabaseType;
import com.j256.ormlite.db.OracleDatabaseType;
import com.j256.ormlite.db.PostgresDatabaseType;
import com.j256.ormlite.db.SqlServerDatabaseType;
import com.j256.ormlite.db.SqlServerJtdsDatabaseType;
import com.j256.ormlite.db.SqliteDatabaseType;
import com.j256.ormlite.jdbc.JdbcConnectionSource;
import java.lang.reflect.Constructor;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DatabaseTypeUtils {
    private static Map<String, Constructor<? extends DatabaseType>> constructorMap = new HashMap<String, Constructor<? extends DatabaseType>>();

    private DatabaseTypeUtils() {
    }

    @Deprecated
    public static void loadDriver(String databaseUrl) throws ClassNotFoundException {
    }

    @Deprecated
    public static JdbcConnectionSource createJdbcConnectionSource(String databaseUrl) throws SQLException {
        return new JdbcConnectionSource(databaseUrl);
    }

    @Deprecated
    public static JdbcConnectionSource createJdbcConnectionSource(String databaseUrl, String userName, String password) throws SQLException {
        return new JdbcConnectionSource(databaseUrl, userName, password);
    }

    public static DatabaseType createDatabaseType(String databaseUrl) {
        String dbTypePart = DatabaseTypeUtils.extractDbType(databaseUrl);
        Constructor<? extends DatabaseType> constructor = constructorMap.get(dbTypePart);
        if (constructor == null) {
            throw new IllegalArgumentException("Unknown database-type url part '" + dbTypePart + "' in: " + databaseUrl);
        }
        try {
            return constructor.newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Problems calling constructor " + constructor, e);
        }
    }

    private static void addDriver(Class<? extends DatabaseType> dbClass) {
        DatabaseType driverType;
        Constructor<? extends DatabaseType> constructor;
        try {
            constructor = dbClass.getConstructor(new Class[0]);
            driverType = constructor.newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new IllegalStateException("Could not construct driver class " + dbClass, e);
        }
        String urlPart = driverType.getDriverUrlPart();
        if (!constructorMap.containsKey(urlPart)) {
            constructorMap.put(urlPart, constructor);
        }
    }

    private static String extractDbType(String databaseUrl) {
        if (!databaseUrl.startsWith("jdbc:")) {
            throw new IllegalArgumentException("Database URL was expected to start with jdbc: but was " + databaseUrl);
        }
        String[] urlParts = databaseUrl.split(":");
        if (urlParts.length < 2) {
            throw new IllegalArgumentException("Database URL was expected to be in the form: jdbc:db-type:... but was " + databaseUrl);
        }
        return urlParts[1];
    }

    static {
        DatabaseTypeUtils.addDriver(MysqlDatabaseType.class);
        DatabaseTypeUtils.addDriver(PostgresDatabaseType.class);
        DatabaseTypeUtils.addDriver(H2DatabaseType.class);
        DatabaseTypeUtils.addDriver(DerbyEmbeddedDatabaseType.class);
        DatabaseTypeUtils.addDriver(SqliteDatabaseType.class);
        DatabaseTypeUtils.addDriver(HsqldbDatabaseType.class);
        DatabaseTypeUtils.addDriver(OracleDatabaseType.class);
        DatabaseTypeUtils.addDriver(SqlServerDatabaseType.class);
        DatabaseTypeUtils.addDriver(SqlServerJtdsDatabaseType.class);
        DatabaseTypeUtils.addDriver(Db2DatabaseType.class);
    }
}

