/*
 * Decompiled with CFR 0.152.
 */
package com.j256.ormlite.logger;

import com.j256.ormlite.logger.Log;
import java.lang.reflect.Method;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Log4jLog
implements Log {
    private Object logger;
    private static Method getLoggerMethod;
    private static Method isEnabledForMethod;
    private static Object traceLevel;
    private static Object debugLevel;
    private static Object infoLevel;
    private static Object warningLevel;
    private static Object errorLevel;
    private static Object fatalLevel;
    private static Method logMethod;
    private static Method logThrowableMethod;

    public Log4jLog(String className) {
        if (getLoggerMethod == null) {
            Log4jLog.findMethods();
        }
        if (getLoggerMethod != null) {
            try {
                this.logger = getLoggerMethod.invoke(null, className);
            }
            catch (Exception e) {
                this.logger = null;
            }
        }
    }

    public boolean isLevelEnabled(Log.Level level) {
        return this.isEnabledFor(this.levelToJavaLevel(level));
    }

    public void log(Log.Level level, String msg) {
        this.logMessage(this.levelToJavaLevel(level), msg);
    }

    public void log(Log.Level level, String msg, Throwable t) {
        this.logMessage(this.levelToJavaLevel(level), msg, t);
    }

    private static void findMethods() {
        Class<?> levelClazz;
        Class<?> priorityClazz;
        Class<?> clazz;
        try {
            clazz = Class.forName("org.apache.log4j.Logger");
        }
        catch (ClassNotFoundException e) {
            return;
        }
        getLoggerMethod = Log4jLog.getMethod(clazz, "getLogger", String.class);
        try {
            priorityClazz = Class.forName("org.apache.log4j.Priority");
        }
        catch (ClassNotFoundException e) {
            return;
        }
        isEnabledForMethod = Log4jLog.getMethod(clazz, "isEnabledFor", priorityClazz);
        try {
            levelClazz = Class.forName("org.apache.log4j.Level");
        }
        catch (ClassNotFoundException e) {
            return;
        }
        traceLevel = Log4jLog.getLevelField(levelClazz, "TRACE");
        debugLevel = Log4jLog.getLevelField(levelClazz, "DEBUG");
        infoLevel = Log4jLog.getLevelField(levelClazz, "INFO");
        warningLevel = Log4jLog.getLevelField(levelClazz, "WARN");
        errorLevel = Log4jLog.getLevelField(levelClazz, "ERROR");
        fatalLevel = Log4jLog.getLevelField(levelClazz, "FATAL");
        logMethod = Log4jLog.getMethod(clazz, "log", priorityClazz, Object.class);
        logThrowableMethod = Log4jLog.getMethod(clazz, "log", priorityClazz, Object.class, Throwable.class);
    }

    private boolean isEnabledFor(Object level) {
        if (this.logger != null) {
            try {
                return (Boolean)isEnabledForMethod.invoke(this.logger, level);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    private void logMessage(Object level, String message) {
        if (this.logger != null && logMethod != null) {
            try {
                logMethod.invoke(this.logger, level, message);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void logMessage(Object level, String message, Throwable t) {
        if (this.logger != null && logThrowableMethod != null) {
            try {
                logThrowableMethod.invoke(this.logger, level, message, t);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    private static Method getMethod(Class<?> clazz, String methodName, Class<?> ... parameterTypes) {
        try {
            return clazz.getMethod(methodName, parameterTypes);
        }
        catch (Exception e) {
            return null;
        }
    }

    private static Object getLevelField(Class<?> clazz, String fieldName) {
        try {
            return clazz.getField(fieldName).get(null);
        }
        catch (Exception e) {
            return null;
        }
    }

    private Object levelToJavaLevel(Log.Level level) {
        switch (level) {
            case TRACE: {
                return traceLevel;
            }
            case DEBUG: {
                return debugLevel;
            }
            case INFO: {
                return infoLevel;
            }
            case WARNING: {
                return warningLevel;
            }
            case ERROR: {
                return errorLevel;
            }
            case FATAL: {
                return fatalLevel;
            }
        }
        return infoLevel;
    }
}

