/*
 * Decompiled with CFR 0.152.
 */
package com.j256.ormlite.jdbc;

import com.j256.ormlite.dao.ObjectCache;
import com.j256.ormlite.field.FieldType;
import com.j256.ormlite.jdbc.JdbcCompiledStatement;
import com.j256.ormlite.jdbc.JdbcDatabaseResults;
import com.j256.ormlite.jdbc.TypeValMapper;
import com.j256.ormlite.stmt.GenericRowMapper;
import com.j256.ormlite.stmt.StatementBuilder;
import com.j256.ormlite.support.CompiledStatement;
import com.j256.ormlite.support.DatabaseConnection;
import com.j256.ormlite.support.DatabaseResults;
import com.j256.ormlite.support.GeneratedKeyHolder;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Savepoint;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JdbcDatabaseConnection
implements DatabaseConnection {
    private static final String JDBC_META_TABLE_NAME_COLUMN = "TABLE_NAME";
    private static Object[] noArgs = new Object[0];
    private static FieldType[] noArgTypes = new FieldType[0];
    private static GenericRowMapper<Long> longWrapper = new OneLongWrapper();
    private Connection connection;
    private Boolean supportsSavePoints = null;

    public JdbcDatabaseConnection(Connection connection) {
        this.connection = connection;
    }

    public boolean isAutoCommitSupported() throws SQLException {
        return true;
    }

    public boolean getAutoCommit() throws SQLException {
        return this.connection.getAutoCommit();
    }

    public void setAutoCommit(boolean autoCommit) throws SQLException {
        this.connection.setAutoCommit(autoCommit);
    }

    public Savepoint setSavePoint(String name) throws SQLException {
        if (this.supportsSavePoints == null) {
            DatabaseMetaData metaData = this.connection.getMetaData();
            this.supportsSavePoints = metaData.supportsSavepoints();
        }
        if (this.supportsSavePoints.booleanValue()) {
            return this.connection.setSavepoint(name);
        }
        return null;
    }

    public void commit(Savepoint savepoint) throws SQLException {
        if (savepoint == null) {
            this.connection.commit();
        } else {
            this.connection.releaseSavepoint(savepoint);
        }
    }

    public void rollback(Savepoint savepoint) throws SQLException {
        if (savepoint == null) {
            this.connection.rollback();
        } else {
            this.connection.rollback(savepoint);
        }
    }

    public CompiledStatement compileStatement(String statement, StatementBuilder.StatementType type, FieldType[] argFieldTypes) throws SQLException {
        return new JdbcCompiledStatement(this.connection.prepareStatement(statement, 1003, 1007), type);
    }

    public void close() throws SQLException {
        this.connection.close();
    }

    public boolean isClosed() throws SQLException {
        return this.connection.isClosed();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int insert(String statement, Object[] args, FieldType[] argFieldTypes, GeneratedKeyHolder keyHolder) throws SQLException {
        PreparedStatement stmt = keyHolder == null ? this.connection.prepareStatement(statement) : this.connection.prepareStatement(statement, 1);
        try {
            this.statementSetArgs(stmt, args, argFieldTypes);
            int rowN = stmt.executeUpdate();
            if (keyHolder != null) {
                ResultSet resultSet = stmt.getGeneratedKeys();
                ResultSetMetaData metaData = resultSet.getMetaData();
                int colN = metaData.getColumnCount();
                while (resultSet.next()) {
                    for (int colC = 1; colC <= colN; ++colC) {
                        Number id = this.getIdColumnData(resultSet, metaData, colC);
                        keyHolder.addKey(id);
                    }
                }
            }
            int n = rowN;
            return n;
        }
        finally {
            stmt.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int update(String statement, Object[] args, FieldType[] argFieldTypes) throws SQLException {
        PreparedStatement stmt = this.connection.prepareStatement(statement);
        try {
            this.statementSetArgs(stmt, args, argFieldTypes);
            int n = stmt.executeUpdate();
            return n;
        }
        finally {
            stmt.close();
        }
    }

    public int delete(String statement, Object[] args, FieldType[] argFieldTypes) throws SQLException {
        return this.update(statement, args, argFieldTypes);
    }

    public <T> Object queryForOne(String statement, Object[] args, FieldType[] argFieldTypes, GenericRowMapper<T> rowMapper) throws SQLException {
        return this.queryForOne(statement, args, argFieldTypes, rowMapper, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> Object queryForOne(String statement, Object[] args, FieldType[] argFieldTypes, GenericRowMapper<T> rowMapper, ObjectCache objectCache) throws SQLException {
        PreparedStatement stmt = this.connection.prepareStatement(statement, 1003, 1007);
        try {
            this.statementSetArgs(stmt, args, argFieldTypes);
            JdbcDatabaseResults results = new JdbcDatabaseResults(stmt, stmt.executeQuery(), objectCache);
            if (!results.next()) {
                Object var8_8 = null;
                return var8_8;
            }
            Object first = rowMapper.mapRow((DatabaseResults)results);
            if (results.next()) {
                Object object = MORE_THAN_ONE;
                return object;
            }
            Object object = first;
            return object;
        }
        finally {
            stmt.close();
        }
    }

    public long queryForLong(String statement) throws SQLException {
        Object result = this.queryForOne(statement, noArgs, noArgTypes, longWrapper, null);
        if (result == null) {
            throw new SQLException("No results returned in query-for-long: " + statement);
        }
        if (result == MORE_THAN_ONE) {
            throw new SQLException("More than 1 result returned in query-for-long: " + statement);
        }
        return (Long)result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isTableExists(String tableName) throws SQLException {
        DatabaseMetaData metaData = this.connection.getMetaData();
        ResultSet results = null;
        try {
            results = metaData.getTables(null, null, "%", new String[]{"TABLE"});
            if (!results.next()) {
                boolean bl = false;
                return bl;
            }
            int col = results.findColumn(JDBC_META_TABLE_NAME_COLUMN);
            do {
                String dbTableName;
                if (!tableName.equalsIgnoreCase(dbTableName = results.getString(col))) continue;
                boolean bl = true;
                return bl;
            } while (results.next());
            boolean bl = false;
            return bl;
        }
        finally {
            if (results != null) {
                results.close();
            }
        }
    }

    public Connection getInternalConnection() {
        return this.connection;
    }

    public void setInternalConnection(Connection connection) {
        this.connection = connection;
    }

    private Number getIdColumnData(ResultSet resultSet, ResultSetMetaData metaData, int columnIndex) throws SQLException {
        int typeVal = metaData.getColumnType(columnIndex);
        switch (typeVal) {
            case -5: 
            case 2: 
            case 3: {
                return resultSet.getLong(columnIndex);
            }
            case 4: {
                return resultSet.getInt(columnIndex);
            }
        }
        throw new SQLException("Unknown DataType for typeVal " + typeVal + " in column " + columnIndex);
    }

    private void statementSetArgs(PreparedStatement stmt, Object[] args, FieldType[] argFieldTypes) throws SQLException {
        for (int i = 0; i < args.length; ++i) {
            Object arg = args[i];
            int typeVal = TypeValMapper.getTypeValForSqlType(argFieldTypes[i].getSqlType());
            if (arg == null) {
                stmt.setNull(i + 1, typeVal);
                continue;
            }
            stmt.setObject(i + 1, arg, typeVal);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class OneLongWrapper
    implements GenericRowMapper<Long> {
        private OneLongWrapper() {
        }

        public Long mapRow(DatabaseResults rs) throws SQLException {
            return rs.getLong(0);
        }
    }
}

