/*
 * Decompiled with CFR 0.152.
 */
package com.j256.ormlite.jdbc;

import com.j256.ormlite.dao.ObjectCache;
import com.j256.ormlite.field.SqlType;
import com.j256.ormlite.jdbc.JdbcDatabaseResults;
import com.j256.ormlite.jdbc.TypeValMapper;
import com.j256.ormlite.stmt.StatementBuilder;
import com.j256.ormlite.support.CompiledStatement;
import com.j256.ormlite.support.DatabaseResults;
import java.sql.PreparedStatement;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;

public class JdbcCompiledStatement
implements CompiledStatement {
    private final PreparedStatement preparedStatement;
    private final StatementBuilder.StatementType type;
    private ResultSetMetaData metaData = null;

    public JdbcCompiledStatement(PreparedStatement preparedStatement, StatementBuilder.StatementType type) {
        this.preparedStatement = preparedStatement;
        this.type = type;
    }

    public int getColumnCount() throws SQLException {
        if (this.metaData == null) {
            this.metaData = this.preparedStatement.getMetaData();
        }
        return this.metaData.getColumnCount();
    }

    public String getColumnName(int column) throws SQLException {
        if (this.metaData == null) {
            this.metaData = this.preparedStatement.getMetaData();
        }
        return this.metaData.getColumnName(column + 1);
    }

    public int runUpdate() throws SQLException {
        if (this.type == StatementBuilder.StatementType.SELECT) {
            throw new IllegalArgumentException("Cannot call update on a " + this.type + " statement");
        }
        return this.preparedStatement.executeUpdate();
    }

    public DatabaseResults runQuery() throws SQLException {
        return this.runQuery(null);
    }

    public DatabaseResults runQuery(ObjectCache objectCache) throws SQLException {
        if (this.type != StatementBuilder.StatementType.SELECT) {
            throw new IllegalArgumentException("Cannot call query on a " + this.type + " statement");
        }
        return new JdbcDatabaseResults(this.preparedStatement, this.preparedStatement.executeQuery(), objectCache);
    }

    public int runExecute() throws SQLException {
        if (this.type != StatementBuilder.StatementType.EXECUTE) {
            throw new IllegalArgumentException("Cannot call execute on a " + this.type + " statement");
        }
        this.preparedStatement.execute();
        return this.preparedStatement.getUpdateCount();
    }

    public void close() throws SQLException {
        this.preparedStatement.close();
    }

    public void setNull(int parameterIndex, SqlType sqlType) throws SQLException {
        this.preparedStatement.setNull(parameterIndex + 1, TypeValMapper.getTypeValForSqlType(sqlType));
    }

    public void setObject(int parameterIndex, Object obj, SqlType sqlType) throws SQLException {
        this.preparedStatement.setObject(parameterIndex + 1, obj, TypeValMapper.getTypeValForSqlType(sqlType));
    }

    public void setMaxRows(int max) throws SQLException {
        this.preparedStatement.setMaxRows(max);
    }

    boolean getMoreResults() throws SQLException {
        return this.preparedStatement.getMoreResults();
    }
}

